/**
 * sa-manager - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.jbi.sugenerator;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.jbi.util.SOAAddress;
import com.ebmwebsourcing.jbi.util.Util;
import com.ebmwebsourcing.petals.services.generation.AbstractJbiXml;
import com.ebmwebsourcing.petals.services.generation.JbiBeanDelegate;
import com.ebmwebsourcing.petals.services.generation.JbiUtils;
import com.ebmwebsourcing.petals.services.generation.cdk5.CdkConsumes5BeanDelegate.MEP;
import com.ebmwebsourcing.petals.services.generation.cdk5.components.BpelProvides10;
import com.ebmwebsourcing.petals.services.generation.cdk5.components.SoapConsumes40;
import com.ebmwebsourcing.petals.services.generation.cdk5.components.SoapProvides40;
import com.ebmwebsourcing.petals.services.generation.cdk5.components.SoapProvides40.SoapVersion;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;


/*
 * Generate some SUs as a File 
 */
public final class SuGenerator {

	private static final Logger log = Logger.getLogger(SuGenerator.class.getCanonicalName());

	public static String bpelComponentName = "petals-se-bpel";
	public static String soapComponentName = "petals-bc-soap"; 

	
	public static File generateBPELProvide(Map<File, List<SOAAddress>> bpelDescriptionFiles,
			File bpelFile,
			Collection<File> wsdls,
			File installFolder) throws IOException {
	    
		if(!installFolder.exists()){
			boolean ok = installFolder.mkdirs();
			if (!ok) {
				log.severe("failed to mkdirs "+installFolder.getAbsolutePath());
				return null;
			}
		}

		// Create the jbi.xml for the service-unit
		AbstractJbiXml genDelegate = new AbstractJbiXml();
		genDelegate.setComponentName( bpelComponentName );

		List<JbiBeanDelegate> provides = new ArrayList<JbiBeanDelegate>();
		for(File currentWsdlBpel : bpelDescriptionFiles.keySet()) {
			List<SOAAddress> providesList = bpelDescriptionFiles.get(currentWsdlBpel);
			for(SOAAddress provide : providesList){
				BpelProvides10 jbiBean = new BpelProvides10();
				jbiBean.setEndpointName( provide.getEndpoint() );
				jbiBean.setInterfaceName( provide.get_interface().getLocalPart() );
				jbiBean.setInterfaceNsUri(provide.get_interface().getNamespaceURI() );
				jbiBean.setServiceName( provide.getService().getLocalPart() );
				jbiBean.setServiceNsUri( provide.getService().getNamespaceURI() );

				jbiBean.setProcessName( bpelFile.getName() );

				jbiBean.setWsdl(currentWsdlBpel.getName());

				for(File wsdl : wsdls) {
					//File temp = new File(installFolder, wsdlCurrent.getName());
					//jbiBean.putFileToImport(wsdlCurrent.getName(), temp);
					jbiBean.putFileToImport(wsdl.getName(),wsdl);
				}
				jbiBean.putFileToImport(currentWsdlBpel.getName(), currentWsdlBpel);

				//jbiBean.putFileToImport(bpelFileName, new File(installFolder, bpelFileName));
				jbiBean.putFileToImport(bpelFile.getName(), bpelFile);
				
				provides.add(jbiBean);
			}
			log.fine("number of bpel su provides : "+provides.size());
		}

		String jbiXmlContent = genDelegate.createJbiDescriptor( provides).toString();
		
		File res = null;
		if(provides.size() > 0){

			// Create the service-unit name
			String suName = JbiUtils.createSuName(
					provides.get(0).getSuType(),
					provides.get(0).getServiceName()+System.currentTimeMillis(),
					! provides.get(0).isProvides()) +".zip";


			// Create the service-unit file
			res = new File(installFolder, suName );

			System.out.println("List of files to import : "+provides.get(0).getFilesToImport());
			res = JbiUtils.createJbiArchive(
					res.getAbsolutePath(),
					jbiXmlContent,
					provides.get(0).getFilesToImport());
		}
		return res;
	}




	public static File generateDefaultSoapProvide(String serviceAddress,
			String endpointName,
			QName interfaceQName,
			QName serviceQName,
			String wsdl,
			Collection<File> filesToImport,
			File installFolder) throws IOException, URISyntaxException, XmlObjectReadException{

		return generateSOAPProvide(serviceAddress,
				endpointName,
				interfaceQName,
				serviceQName,
				wsdl,
				"0",
				true,
				false,
				false,
				false,
				false,
				filesToImport,
				installFolder);
	}

	public static File generateSOAPProvide(String serviceAddress,
			String endpointName,
			QName interfaceQName,
			QName serviceQName,
			String wsdl,
			String timeout,
			Boolean validateWsdl,
			Boolean retryPolicy,
			Boolean forwardSecuritySubject,
			Boolean forwardMessageProperties,
			Boolean forwardAttachments,
			Collection<File> filesToImport,
			File installFolder) throws IOException, URISyntaxException, XmlObjectReadException{


		//Create folder to install if not exists

		if(!installFolder.exists()){
			boolean ok = installFolder.mkdirs();
			if (!ok) {
				log.severe("failed to mkdirs "+installFolder.getAbsolutePath());
				return null;
			}
		}


		AbstractJbiXml genDelegate = new AbstractJbiXml();
		genDelegate.setComponentName( soapComponentName );

		SoapProvides40 jbiBean = new SoapProvides40();

		jbiBean.setServiceAddress(serviceAddress);		
		jbiBean.setEndpointName(endpointName);
		jbiBean.setInterfaceName(interfaceQName.getLocalPart());
		jbiBean.setInterfaceNsUri(interfaceQName.getNamespaceURI());
		jbiBean.setServiceName(serviceQName.getLocalPart());
		jbiBean.setServiceNsUri(serviceQName.getNamespaceURI());
		jbiBean.setWsdl(wsdl);

		jbiBean.setTimeout(timeout);
		jbiBean.setValidateWsdl(validateWsdl);


		if(filesToImport != null){
		    for(File file : filesToImport) {
				if(file.getName().equals(wsdl)){
					/*
					 * Retrieve soap version
					 */
					Definitions wsdlDesc = Util.readDefinitions(file.toURI().toURL());
					Binding bind = wsdlDesc.getServiceByName(serviceQName.getLocalPart()).getPortByName(endpointName).findBinding();
					com.ebmwebsourcing.soapbinding11.api.element.Binding soapbind = SoapBindingHelper.getSoapBinding(bind);
					if(soapbind != null && soapbind.getXmlObjectQName().getNamespaceURI().equals(com.ebmwebsourcing.soapbinding11.api.Constants.SOAPBINDING11_NS_URI)){
						jbiBean.setSoapVersion(SoapVersion.v11);
					}else{
						jbiBean.setSoapVersion(SoapVersion.v12);
					}
				}
				jbiBean.putFileToImport(file.getName(), file);
			}
		}

		List<JbiBeanDelegate> tmp = new ArrayList<JbiBeanDelegate>();
		tmp.add((JbiBeanDelegate)jbiBean);
		
		String jbiXmlContent = genDelegate.createJbiDescriptor( tmp ).toString();

		// Create the service-unit name
		String suName = JbiUtils.createSuName(
				jbiBean.getSuType(),
				jbiBean.getServiceName()+System.currentTimeMillis()+new Random(10).nextInt(),
				! jbiBean.isProvides());

		// Create the service-unit file
		File suFile = new File( System.getProperty("java.io.tmpdir"), suName + ".zip" );
		suFile = JbiUtils.createJbiArchive(
				suFile.getAbsolutePath(),
				jbiXmlContent,
				jbiBean.getFilesToImport());
		
		return suFile;
	}



	public static File generateSOAPConsume(
			String endpointName,
			QName interfaceQName,
			QName serviceQName,
			QName operationQName,
			MEP mep,
			String ServiceName,
			File installFolder) throws IOException {

		//Create folder to install if not exists

		if(!installFolder.exists()){
			boolean ok = installFolder.mkdirs();
			if (!ok) {
				log.severe("failed to mkdirs "+installFolder.getAbsolutePath());
				return null;
			}
		}

		AbstractJbiXml genDelegate = new AbstractJbiXml();
		genDelegate.setComponentName(soapComponentName);

		//Set the SOAP Bean
		SoapConsumes40 jbiSoapConsume = new SoapConsumes40();
		jbiSoapConsume.setServiceEndpoint(endpointName);
		jbiSoapConsume.setEndpointName(endpointName);
		jbiSoapConsume.setInterfaceName(interfaceQName.getLocalPart());
		jbiSoapConsume.setInterfaceNsUri(interfaceQName.getNamespaceURI());
		jbiSoapConsume.setServiceName(serviceQName.getLocalPart());
		jbiSoapConsume.setServiceNsUri(serviceQName.getNamespaceURI());

		if(mep != null){
			jbiSoapConsume.setMep(mep);
		}
		if(operationQName != null){
			jbiSoapConsume.setOperation(operationQName.getLocalPart());
			jbiSoapConsume.setOperationNsUri(operationQName.getNamespaceURI());
		}
		
		//Create the jbi descriptor
		List<JbiBeanDelegate> tmp = new ArrayList<JbiBeanDelegate>();
		tmp.add((JbiBeanDelegate)jbiSoapConsume);
		String jbiXmlContent = genDelegate.createJbiDescriptor(tmp).toString();

		// Create the service-unit name
		String suName = JbiUtils.createSuName(
				jbiSoapConsume.getSuType(),
				jbiSoapConsume.getServiceName()+System.currentTimeMillis(),
				! jbiSoapConsume.isProvides());

		// Create the service-unit file
		File suFile = new File( System.getProperty("java.io.tmpdir"), suName + ".zip" );
		suFile = JbiUtils.createJbiArchive(
				suFile.getAbsolutePath(),
				jbiXmlContent,
				jbiSoapConsume.getFilesToImport());
		return suFile;
	}
	
}
