/**
 * sa-manager - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.jbi.util;

import java.net.URL;
import java.util.Collection;

import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public final class Util {
    
	public static Endpoint findEndpoint(Interface interf, Collection<? extends Service> serviceList) {
		for(Service service : serviceList) {
			if(service != null && service.getEndpoints() != null && service.getEndpoints().length > 0){
			    for(Endpoint endpoint : service.getEndpoints()) {
			        if(endpoint.getBinding()!=null && endpoint.getBinding().getInterface().equals(interf)){
			            return endpoint;
			        }
			    }
			}
		}
		return null;
	}

	public static Definitions readDefinitions (URL wsdlUrl) throws XmlObjectReadException {
		// create factory: can be static
		XmlContextFactory xmlContextFactory = new XmlContextFactory();

		// create context: can be static
		XmlContext xmlContext = xmlContextFactory.newContext();

		// create generic reader: cannot be static!!! not thread safe!!!
		XmlObjectReader reader = xmlContext.createReader();

		// read WSDL 1.1 definitions from url
		Definitions definitions = reader.readDocument(wsdlUrl, Definitions.class);
		return definitions;
	}
	
	public static String removeExtension(String fileName) {
		int index = fileName.lastIndexOf('.');
		if(index!=-1) {
			return fileName.substring(0, index);
		}
		return fileName;
	}

}
