/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * A bean used in the generation of the JBI descriptor for the SCA component of Petals.
 * @author Vincent Zurczak - EBM WebSourcing
 */
public abstract class JbiBeanDelegate {

	String interfaceName, serviceName, endpointName;
	String interfaceNsUri, serviceNsUri;
	boolean provides = true;

	/**
	 * Name spaces are sorted by natural (key) prefix order.
	 */
	final Map<String,String> namespaces = new TreeMap<String,String>();

	final Map<String,File> fileNameToFile = new HashMap<String,File>();



	/**
	 * @return the interfaceName
	 */
	public String getInterfaceName() {
		return this.interfaceName;
	}

	/**
	 * @param interfaceName the interfaceName to set
	 */
	public void setInterfaceName( String interfaceName ) {
		this.interfaceName = interfaceName;
	}

	/**
	 * @return the serviceName
	 */
	public String getServiceName() {
		return this.serviceName;
	}

	/**
	 * @param serviceName the serviceName to set
	 */
	public void setServiceName( String serviceName ) {
		this.serviceName = serviceName;
	}

	/**
	 * @return the endpointName
	 */
	public String getEndpointName() {
		return this.endpointName;
	}

	/**
	 * @param endpointName the endpointName to set
	 */
	public void setEndpointName( String endpointName ) {
		this.endpointName = endpointName;
	}

	/**
	 * @return the interfaceNsUri
	 */
	public String getInterfaceNsUri() {
		return this.interfaceNsUri;
	}

	/**
	 * @param interfaceNsUri the interfaceNsUri to set
	 */
	public void setInterfaceNsUri( String interfaceNsUri ) {
		this.interfaceNsUri = interfaceNsUri;
	}

	/**
	 * @return the serviceNsUri
	 */
	public String getServiceNsUri() {
		return this.serviceNsUri;
	}

	/**
	 * @param serviceNsUri the serviceNsUri to set
	 */
	public void setServiceNsUri( String serviceNsUri ) {
		this.serviceNsUri = serviceNsUri;
	}


	/**
	 * @return the provides (true by default)
	 */
	public abstract boolean isProvides();


	/**
	 * Adds a name space declaration in the jbi.xml to generate.
	 * @param prefix
	 * @param uri
	 */
	public void addNamespace( String prefix, String uri ) {
		this.namespaces.put( prefix, uri );
	}


	/**
	 * @return the namespaces
	 */
	public Map<String, String> getNamespaces() {
		return this.namespaces;
	}

	/**
	 * Gets the CDK section as a string (which includes formatting).
	 * @return a non-null string
	 */
	public abstract String getCdkSection();


	/**
	 * Gets the component section as a string (which includes formatting).
	 * @return a non-null string
	 */
	public abstract String getComponentSection();


	/**
	 * @return the SU type (e.g. SOAP, EJB).
	 */
	public abstract String getSuType();


	/**
	 * @see java.util.Map#clear()
	 */
	public void clearFilesToImport() {
		this.fileNameToFile.clear();
	}

	/**
	 * @param zipKey
	 * @return
	 * @see java.util.Map#get(java.lang.Object)
	 */
	public File getFileToImport( String zipKey ) {
		return this.fileNameToFile.get( zipKey );
	}

	/**
	 * @param zipKey
	 * @param file
	 * @return
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	public File putFileToImport( String zipKey, File file ) {
		return this.fileNameToFile.put( zipKey, file );
	}


	/**
	 * @return
	 */
	public Map<String, File> getFilesToImport() {
		return this.fileNameToFile;
	}
}
