/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation.cdk5.components;

import com.ebmwebsourcing.petals.services.generation.cdk5.CdkProvides5BeanDelegate;

/**
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class BpelProvides10 extends CdkProvides5BeanDelegate {

	private String processName;
	private int poolSize = 1;


	/**
	 * Constructor.
	 */
	public BpelProvides10() {
		super();
		addNamespace( "bpel", "http://petals.ow2.org/components/petals-bpel-engine/version-1" );
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate
	 * #getComponentSection()
	 */
	@Override
	public String getComponentSection() {

		StringBuffer buf = new StringBuffer();
		buf.append( "\t\t\t<bpel:bpel>" + this.processName + "</bpel:bpel>\n" );
		buf.append( "\t\t\t<bpel:poolsize>" + this.poolSize + "</bpel:poolsize>\n" );
		return buf.toString();
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate
	 * #getSuType()
	 */
	@Override
	public String getSuType() {
		return "BPEL";
	}


	/**
	 * @return the processName
	 */
	public String getProcessName() {
		return this.processName;
	}


	/**
	 * @param processName the processName to set
	 */
	public void setProcessName( String processName ) {
		this.processName = processName;
	}


	/**
	 * @return the poolSize
	 */
	public int getPoolSize() {
		return this.poolSize;
	}


	/**
	 * @param poolSize the poolSize to set
	 */
	public void setPoolSize( int poolSize ) {
		this.poolSize = poolSize;
	}
}
