/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation.cdk5.components;

import com.ebmwebsourcing.petals.services.generation.cdk5.CdkConsumes5BeanDelegate;

/**
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class SoapConsumes40 extends CdkConsumes5BeanDelegate {

	private String serviceEndpoint;


	/**
	 * Constructor.
	 */
	public SoapConsumes40() {
		super();
		addNamespace( "soap", "http://petals.ow2.org/components/soap/version-4" );
	}


	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate
	 * #getComponentSection()
	 */
	@Override
	public String getComponentSection() {

		String result = "";
		result += "\t\t\t<soap:address>" + this.serviceEndpoint + "</soap:address>\n";
		result += "\t\t\t<soap:remove-root>false</soap:remove-root>\n";
		result += "\t\t\t<soap:mode>SOAP</soap:mode>\n";
		result += "\t\t\t<soap:rest-add-namespace-prefix>soapbc</soap:rest-add-namespace-prefix>\n";

		return result;
	}


	/**
	 * @return the serviceEndpoint
	 */
	public String getServiceEndpoint() {
		return this.serviceEndpoint;
	}


	/**
	 * @param serviceEndpoint the serviceEndpoint to set
	 */
	public void setServiceEndpoint( String serviceEndpoint ) {
		this.serviceEndpoint = serviceEndpoint;
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#getSuType()
	 */
	@Override
	public String getSuType() {
		return "SOAP";
	}
}
