/**
 * petalsbpm-client - Geasy BPMN Editor Client - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.core;

import java.util.HashSet;

import com.ebmwebsourcing.geasyschema.domain.Schema;
import com.ebmwebsourcing.geasyschema.domain.mock.SchemaMockDB;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IPlugin;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.EditorController;
import com.ebmwebsourcing.geasytools.webeditor.ui.core.EditorView;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.client.component.bpmn.WelcomeComponent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.process.DescriptiveBPMNPrivateProcessPlugin;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.process.ExecutableBPMNPrivateProcessPlugin;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.DefinitionsAvailableImport;
import com.google.gwt.core.client.EntryPoint;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;

public class BPMNEditorClient implements EntryPoint {

    public void onModuleLoad() {
     
    	
        ////TODO: ONLY FOR TEST +> REMOVE
//    	XSDImportBean xsdImportBean1 = new XSDImportBean(new NamespaceDeclaration("ns1", "http://ns1"),SchemaMockDB.getSchema1());
//    	xsdImportBean1.setLocation("loc1");
//    	//xsdImportBean1.setNamespace("ns1");
//    	
//    	XSDImportBean xsdImportBean2 = new XSDImportBean(new NamespaceDeclaration("ns2", "http://ns2"),SchemaMockDB.getSchema1());
//    	xsdImportBean2.setLocation("loc2");
//    	//xsdImportBean2.setNamespace("ns2");
//    	
//    	
//    	DefinitionsAvailableImport.getInstance().addImport(xsdImportBean1);
//    	DefinitionsAvailableImport.getInstance().addImport(xsdImportBean2);		
//    	
//    	
    	/////////////----------------------------
    	
    	
    	final EditorView bpmneditorView = new EditorView();
        final Panel panel = (Panel) bpmneditorView.getMainWidget();
        
        


        new Viewport(panel);

        HashSet<IPlugin> plugins = new HashSet<IPlugin>();
        plugins.add(new DescriptiveBPMNPrivateProcessPlugin());
        plugins.add(new ExecutableBPMNPrivateProcessPlugin());
//        plugins.add(new DescriptiveBPMNCollaborationPlugin());
//        plugins.add(new ExecutableBPMNCollaborationPlugin());

        try {
            EditorController ec = new EditorController(bpmneditorView, plugins);

            bpmneditorView.getDefaultLayout().getMainContentPanelPlaceHolder().addComponent(
                    new WelcomeComponent(ec.getEventBus()));

        } catch (Exception e) {
            System.out.println(e);
        }
    }
    
    

	

}
