/**
 * petalsbpm-domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure;

import java.util.Collection;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.WithAttributeExtension;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IEscalationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IPartnerRoleBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.ISignalBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IConditionalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ISignalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ITimerEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IEndPointBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;

public interface IDefinitionsBean extends IMainModelElement, WithAttributeExtension, IModelElement {

    public void addImport(IImportBean i);

    public void removeImport(IImportBean i);

    public void addChoreography(IChoreographyBean c);

    public void removeChoreography(IChoreographyBean c);

    public void addItemDefinition(IItemDefinitionBean i);

    public void removeItemDefinition(IItemDefinitionBean i);

    public IItemDefinitionBean getItemDefinitionById(String id);

    public void addCollaboration(ICollaborationBean c);

    public void removeCollaboration(ICollaborationBean c);

    public List<IParticipantBean> getParticipants();

    public IParticipantBean getParticipantById(String id);

    public void addInterface(IInterfaceBean i);

    public void removeInterface(IInterfaceBean i);

    public IOperationBean getOperationById(String id);

    public void addProcess(IProcessBean p);

    public void removeProcess(IProcessBean p);

    public IProcessBean getProcessById(String id);

    public void addPartnerRole(IPartnerRoleBean pr);

    public void removePartnerRole(IPartnerRoleBean pr);

    public void addMessage(IMessageBean m);

    public void removeMessage(IMessageBean m);

    public void addSignal(ISignalBean m);

    public void removeSignal(ISignalBean m);
    
    public void addEndPoint(IEndPointBean ep);
    
    public void removeEndPoint(IEndPointBean ep);
    
    public void addError(IErrorBean ep);
    
    public void removeError(IErrorBean ep);
    
    public void addEscalation(IEscalationBean ep);
    
    public void removeEscalation(IEscalationBean ep);

    public void addEventDefinition(IEventDefinitionBean ev);
    
    public void removeEventDefinition(IEventDefinitionBean ev);
    
    public IMessageBean getMessageById(String id);
    
    ////////////////////////////////////////////
    /////                                  /////
    /////       GETTERS AND SETTERS        /////
    /////                                  /////
    ////////////////////////////////////////////
    public String getId();

    public void setId(String id);

    public String getName();

    public void setName(String name);
    
    public String getExporter();
    
    public void setExporter(String exporter);
    
    public void setExporterVersion(String exporter);
    
    public String getExporterVersion();
    
    public String getTargetNamespace();

    public void setTargetNamespace(String targetNamespace);

    public String getExpressionLanguage();

    public void setExpressionLanguage(String expressionLanguage);

    public String getTypeLanguage();

    public void setTypeLanguage(String typeLanguage);

    public List<IImportBean> getImports();

    public void setImports(List<IImportBean> imports);

    public List<ICollaborationBean> getCollaborations();

    public void setCollaborations(List<ICollaborationBean> collaborations);

    public List<IProcessBean> getProcesses();

    public List<IInterfaceBean> getInterfaces();
    
    public List<IOperationBean> getOperations();
    
    public List<IPartnerRoleBean> getPartnerRoles();
    
    public List<IMessageBean> getMessages();

    public void setMessages(List<IMessageBean> messages);

    public void setProcesses(List<IProcessBean> processes);

    public void setInterfaces(List<IInterfaceBean> interfaces);

    public void setPartnerRoles(List<IPartnerRoleBean> partnerRoles);

    public List<IItemDefinitionBean> getItemDefinitions();

    public void setItemDefinitions(List<IItemDefinitionBean> itemDefinitions);

    public List<ISignalBean> getSignals();

    public void setSignals(List<ISignalBean> signals);

    public List<IChoreographyBean> getChoreographies();

    public void setChoreographies(List<IChoreographyBean> choreographies);
    
    public void setEndPoints(List<IEndPointBean> ep);
    
    public List<IEndPointBean> getEndPoints();
    
    public void setErrors(List<IErrorBean> ep);
    
    public List<IErrorBean> getErrors();
    
    public void setEscalations(List<IEscalationBean> ep);
    
    public List<IEscalationBean> getEscalations();
    
    public void setEventDefinitions(List<IEventDefinitionBean> evs);
    
    public List<IEventDefinitionBean> getEventDefinitions();
    
    public List<IConditionalEventDefinitionBean> getConditionalEventDefinitions();
    
    public List<IMessageEventDefinitionBean> getMessageEventDefinitions();
    
    public List<ISignalEventDefinitionBean> getSignalEventDefinitions();
    
    public List<ITimerEventDefinitionBean> getTimerEventDefinitions();
    
    public Collection<INamespaceDeclaration> getImportsNsDeclarations();
    
    public INamespaceDeclaration getNsDeclarationByNamespace(String ns);
    
    public INamespaceDeclaration getNsDeclarationByPrefix(String prefix);
    
}
