/**
 * petalsbpm-domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data;

import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;

public interface IDataAssociationBean extends IBaseElementBean {

    public IItemAwareElementBean getTarget();

    public void setTarget(IItemAwareElementBean arg0);

    public void addAssignement(IAssignmentBean arg0);

    public void removeAssignment(IAssignmentBean arg0);

    public void addSource(IItemAwareElementBean arg0);

    public void removeSource(IItemAwareElementBean arg0);

    public List<IAssignmentBean> getAssignements();

    public void setAssignements(List<IAssignmentBean> arg0);

    public List<IItemAwareElementBean> getSources();

    public void setSources(List<IItemAwareElementBean> arg0);

    public IExpressionBean getTransformation();

    public void setTransformation(IExpressionBean exp);
    
    //not part of spec
    void setSourceItem(IItemDefinitionBean item);
    
    IItemDefinitionBean getSourceItem();
    
    void setTargetItem(IItemDefinitionBean item);
    
    IItemDefinitionBean getTargetItem();
}
