/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.IInteractionNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

public class BPELExampleGenerator {
	
	public static String COLLABORATION_ID;
	public static String UPPER_Participant_ID, LOWER_Participant_ID;
	public static String UPPER_LANE_ID, LOWER_LANE_ID;
	
	public static String UPPER_LANE_EL_1_ID, UPPER_LANE_EL_2_ID, UPPER_LANE_EL_3_ID, UPPER_LANE_EL_4_ID, UPPER_LANE_EL_5_ID
		, UPPER_LANE_EL_6_ID, UPPER_LANE_EL_7_ID, UPPER_LANE_EL_8_ID, UPPER_LANE_EL_9_ID, UPPER_LANE_EL_10_ID;
	
	public static String UPPER_LANE_SF_1_ID, UPPER_LANE_SF_2_ID, UPPER_LANE_SF_3_ID, UPPER_LANE_SF_4_ID, UPPER_LANE_SF_5_ID
		, UPPER_LANE_SF_6_ID, UPPER_LANE_SF_7_ID, UPPER_LANE_SF_8_ID, UPPER_LANE_SF_9_ID;
	
	public static String LOWER_LANE_EL_1_ID, LOWER_LANE_EL_2_ID, LOWER_LANE_EL_3_ID, LOWER_LANE_EL_4_ID, LOWER_LANE_EL_5_ID
		, LOWER_LANE_EL_6_ID, LOWER_LANE_EL_7_ID, LOWER_LANE_EL_8_ID;
	
	public static String LOWER_LANE_SF_1_ID, LOWER_LANE_SF_2_ID, LOWER_LANE_SF_3_ID, LOWER_LANE_SF_4_ID, LOWER_LANE_SF_5_ID
		, LOWER_LANE_SF_6_ID, LOWER_LANE_SF_0_ID;
	
	public static String MF_1_ID, MF_2_ID, MF_3_ID;
	
	private static List<FlowNodeBean> upperParticipantNodes;
	private static List<FlowNodeBean> lowerParticipantNodes;
	
	
	public static DefinitionsBean getExample(){
		upperParticipantNodes = new ArrayList<FlowNodeBean>();
		lowerParticipantNodes = new ArrayList<FlowNodeBean>();
		
		DefinitionsBean result = new DefinitionsBean(createUniqueId());
		
		result.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/alertTreatment/definition");
		result.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
		result.setExpressionLanguage("http://www.w3.org/1999/XPath");
		
		result.addCollaboration(buildCollaboration(result));
		
		return result;
	}


	private static CollaborationBean buildCollaboration(DefinitionsBean globalResult) {
		COLLABORATION_ID = createUniqueId();
		CollaborationBean result = new CollaborationBean(COLLABORATION_ID);
		result.setName("AlertConfirmation");
		result.addParticipant(buildUpperParticipant(globalResult));
		result.addParticipant(buildlowerParticipant(globalResult));
		result.setMessageFlows(buildMessageFlows());
		return result;
	}


	private static ParticipantBean buildUpperParticipant(DefinitionsBean globalResult) {
		UPPER_Participant_ID = createUniqueId();
		ParticipantBean result = new ParticipantBean(UPPER_Participant_ID);
		result.setName("Sensor Array");

		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		
		globalResult.addPartnerRole(pr);
		
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(result.getName().replace(" ","")+"Process");
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		process.addLane(buildUpperLane(process, globalResult));
		
		return result;
	}


	private static LaneBean buildUpperLane(ProcessBean process, DefinitionsBean globalResult) {
		UPPER_LANE_ID = createUniqueId();
		LaneBean result = new LaneBean(UPPER_LANE_ID);
		result.setName("Sensor");
		
		//NODES
		UPPER_LANE_EL_1_ID = createUniqueId();
		StartEventBean startEvent = new StartEventBean(UPPER_LANE_EL_1_ID);
		startEvent.setName("Alert reception");
		EventDefinitionBean ed = new MessageEventDefinitionBean(createUniqueId());
		startEvent.addTrigger(ed);
		globalResult.addEventDefinition(ed);
		process.addStartEvent(startEvent);
		result.addStartEvent(startEvent);
		
		UPPER_LANE_EL_2_ID = createUniqueId();
		ReceiveTaskBean task1 = new ReceiveTaskBean(UPPER_LANE_EL_2_ID);
		task1.setName("Receive \r\n alert");
		process.addTask(task1);
		result.addTask(task1);
		
		UPPER_LANE_EL_3_ID = createUniqueId();
		TaskBean task2 = new TaskBean(UPPER_LANE_EL_3_ID);
		task2.setName("Analyze");
		process.addTask(task2);
		result.addTask(task2);
		
		UPPER_LANE_EL_4_ID = createUniqueId();
		SendTaskBean task3 = new SendTaskBean(UPPER_LANE_EL_4_ID);
		task3.setName("Send e-mail");
		result.addTask(task3);
		process.addTask(task3);
		upperParticipantNodes.add(task3);
		
		UPPER_LANE_EL_5_ID = createUniqueId();
		ReceiveTaskBean task4 = new ReceiveTaskBean(UPPER_LANE_EL_5_ID);
		task4.setName("Receive \r\n response");
		result.addTask(task4);
		process.addTask(task4);
		upperParticipantNodes.add(task4);
		
		UPPER_LANE_EL_6_ID = createUniqueId();
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(UPPER_LANE_EL_6_ID);
		result.addGateway(gateway);
		process.addGateway(gateway);
		
		UPPER_LANE_EL_7_ID = createUniqueId();
		TaskBean task5 = new SendTaskBean(UPPER_LANE_EL_7_ID);
		task5.setName("Cancel Alert");
		process.addTask(task5);
		result.addTask(task5);
		
		UPPER_LANE_EL_8_ID = createUniqueId();
		EndEventBean endEvent = new EndEventBean(UPPER_LANE_EL_8_ID);
		EventDefinitionBean ed3 = new MessageEventDefinitionBean(createUniqueId());
		endEvent.addResult(ed3);
		globalResult.addEventDefinition(ed3);
		endEvent.setName("End Alert");
		result.addEndEvent(endEvent);
		process.addEndEvent(endEvent);
		
		UPPER_LANE_EL_9_ID = createUniqueId();
		TaskBean task = new SendTaskBean(UPPER_LANE_EL_9_ID);
		task.setName("Spread Alert");
		result.addTask(task);
		process.addTask(task);
		
		UPPER_LANE_EL_10_ID = createUniqueId();
		EndEventBean endEvent2 = new EndEventBean(UPPER_LANE_EL_10_ID);
		EventDefinitionBean ed2 = new MessageEventDefinitionBean(createUniqueId());
		endEvent2.addResult(ed2);
		globalResult.addEventDefinition(ed2);
		endEvent2.setName("Forward Alert"); 
		result.addEndEvent(endEvent2);
		process.addEndEvent(endEvent2);
		

		//Sequence Flows
		UPPER_LANE_SF_1_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(UPPER_LANE_SF_1_ID);
		sf1.setSourceNode(startEvent);
		sf1.setTargetNode(task1);
		process.addSequenceFlow(sf1);
		
		UPPER_LANE_SF_2_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(UPPER_LANE_SF_2_ID);
		sf2.setSourceNode(task1);
		sf2.setTargetNode(task2);
		process.addSequenceFlow(sf2);
		
		UPPER_LANE_SF_3_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(UPPER_LANE_SF_3_ID);
		sf3.setSourceNode(task2);
		sf3.setTargetNode(task3);
		process.addSequenceFlow(sf3);
		
		UPPER_LANE_SF_4_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(UPPER_LANE_SF_4_ID);
		sf4.setSourceNode(task3);
		sf4.setTargetNode(task4);
		process.addSequenceFlow(sf4);
		
		UPPER_LANE_SF_5_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(UPPER_LANE_SF_5_ID);
		sf5.setSourceNode(task4);
		sf5.setTargetNode(gateway);
		process.addSequenceFlow(sf5);
		
		UPPER_LANE_SF_6_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(UPPER_LANE_SF_6_ID);
		sf6.setSourceNode(gateway);
		sf6.setTargetNode(task);
		ExpressionBean exp = new ExpressionBean(createUniqueId());
		exp.setContent("Alert confirmed");
		sf6.setExpression(exp);
		process.addSequenceFlow(sf6);
		
		UPPER_LANE_SF_7_ID = createUniqueId();
		SequenceFlowBean sf7 = new SequenceFlowBean(UPPER_LANE_SF_7_ID);
		sf7.setSourceNode(gateway);
		sf7.setTargetNode(task5);
		ExpressionBean exp2 = new ExpressionBean(createUniqueId());
		exp2.setContent("Alert cancelled");
		sf7.setExpression(exp2);
		process.addSequenceFlow(sf7);
		
		UPPER_LANE_SF_8_ID = createUniqueId();
		SequenceFlowBean sf8 = new SequenceFlowBean(UPPER_LANE_SF_8_ID);
		sf8.setSourceNode(task);
		sf8.setTargetNode(endEvent2);
		process.addSequenceFlow(sf8);
		
		UPPER_LANE_SF_9_ID = createUniqueId();
		SequenceFlowBean sf9 = new SequenceFlowBean(UPPER_LANE_SF_9_ID);
		sf9.setSourceNode(task5);
		sf9.setTargetNode(endEvent);
		process.addSequenceFlow(sf9);
		
		return result;
	}

	
	
	private static ParticipantBean buildlowerParticipant(DefinitionsBean globalResult) {
		LOWER_Participant_ID = createUniqueId();
		ParticipantBean result = new ParticipantBean(LOWER_Participant_ID);
		result.setName("Expert Board");
		
		
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(result.getName().replace(" ","")+"Process");
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		process.addLane(buildLowerLane(process, globalResult));
		
		return result;
	}
	

	private static LaneBean buildLowerLane(ProcessBean process, DefinitionsBean globalResult) {
		LOWER_LANE_ID = createUniqueId();
		LaneBean result = new LaneBean(LOWER_LANE_ID);
		result.setName("Decider");
		
		//NODES
		LOWER_LANE_EL_1_ID = createUniqueId();
		StartEventBean startEvent = new StartEventBean(LOWER_LANE_EL_1_ID);
		startEvent.setName("Notification reception");
		EventDefinitionBean ed = new MessageEventDefinitionBean(createUniqueId());
		startEvent.addTrigger(ed);
		globalResult.addEventDefinition(ed);
		result.addStartEvent(startEvent);
		process.addStartEvent(startEvent);
		lowerParticipantNodes.add(startEvent);
		
		LOWER_LANE_EL_2_ID = createUniqueId();
		ReceiveTaskBean task1 = new ReceiveTaskBean(LOWER_LANE_EL_2_ID);
		task1.setName("Receive \r\n notification");
		result.addTask(task1);
		process.addTask(task1);

		LOWER_LANE_EL_3_ID = createUniqueId();
		TaskBean task2 = new TaskBean(LOWER_LANE_EL_3_ID);
		task2.setName("Take Decision");
		result.addTask(task2);
		process.addTask(task2);
		
		LOWER_LANE_EL_4_ID = createUniqueId();
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(LOWER_LANE_EL_4_ID);
		result.addGateway(gateway);
		process.addGateway(gateway);
		
		LOWER_LANE_EL_5_ID = createUniqueId();
		TaskBean task3 = new SendTaskBean(LOWER_LANE_EL_5_ID);
		task3.setName("Confirm Alert");
		result.addTask(task3);
		process.addTask(task3);
		
		LOWER_LANE_EL_6_ID = createUniqueId();
		TaskBean task4 = new SendTaskBean(LOWER_LANE_EL_6_ID);
		task4.setName("Cancel Alert");
		result.addTask(task4);
		process.addTask(task4);
		
		LOWER_LANE_EL_7_ID = createUniqueId();
		EndEventBean endEvent1 = new EndEventBean(LOWER_LANE_EL_7_ID);
		EventDefinitionBean ed1 = new MessageEventDefinitionBean(createUniqueId());
		endEvent1.addResult(ed1);
		globalResult.addEventDefinition(ed1);
		endEvent1.setName("Send confirmation"); 
		result.addEndEvent(endEvent1);
		process.addEndEvent(endEvent1);
		lowerParticipantNodes.add(endEvent1);
		
		LOWER_LANE_EL_8_ID = createUniqueId();
		EndEventBean endEvent2 = new EndEventBean(LOWER_LANE_EL_8_ID);
		EventDefinitionBean ed2 = new MessageEventDefinitionBean(createUniqueId());
		endEvent2.addResult(ed2);
		globalResult.addEventDefinition(ed2);
		endEvent2.setName("Send cancellation");  
		result.addEndEvent(endEvent2);
		process.addEndEvent(endEvent2);
		lowerParticipantNodes.add(endEvent2);
		
		//Sequence Flows
		LOWER_LANE_SF_0_ID = createUniqueId();
		SequenceFlowBean sf = new SequenceFlowBean(LOWER_LANE_SF_0_ID);
		sf.setSourceNode(startEvent);
		sf.setTargetNode(task1);
		process.addSequenceFlow(sf);
		
		LOWER_LANE_SF_1_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(LOWER_LANE_SF_1_ID);
		sf1.setSourceNode(task1);
		sf1.setTargetNode(task2);
		process.addSequenceFlow(sf1);
		
		LOWER_LANE_SF_2_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(LOWER_LANE_SF_2_ID);
		sf2.setSourceNode(task2);
		sf2.setTargetNode(gateway);
		process.addSequenceFlow(sf2);
		
		LOWER_LANE_SF_3_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(LOWER_LANE_SF_3_ID);
		sf3.setSourceNode(gateway);
		sf3.setTargetNode(task3);
		ExpressionBean exp = new ExpressionBean(createUniqueId());
		exp.setContent("Real Alert");
		sf3.setExpression(exp);
		process.addSequenceFlow(sf3);
		
		LOWER_LANE_SF_4_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(LOWER_LANE_SF_4_ID);
		sf4.setSourceNode(gateway);
		sf4.setTargetNode(task4);
		ExpressionBean exp2 = new ExpressionBean(createUniqueId());
		exp2.setContent("Unimportant Alert");
		sf4.setExpression(exp2);
		process.addSequenceFlow(sf4);
		
		LOWER_LANE_SF_5_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(LOWER_LANE_SF_5_ID);
		sf5.setSourceNode(task3);
		sf5.setTargetNode(endEvent1);
		process.addSequenceFlow(sf5);
		
		LOWER_LANE_SF_6_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(LOWER_LANE_SF_6_ID);
		sf6.setSourceNode(task4);
		sf6.setTargetNode(endEvent2);
		process.addSequenceFlow(sf6);
		
		
		return result;
	}
	
	
	private static List<IMessageFlowBean> buildMessageFlows() {
		ArrayList<IMessageFlowBean> result = new ArrayList<IMessageFlowBean>();
		
		MF_1_ID = createUniqueId();
		MessageFlowBean messageFlow1 = new MessageFlowBean(MF_1_ID);
		messageFlow1.setSource((IInteractionNodeBean) upperParticipantNodes.get(0));
		messageFlow1.setTarget((IInteractionNodeBean) lowerParticipantNodes.get(0));
		
		MF_2_ID = createUniqueId();
		MessageFlowBean messageFlow2 = new MessageFlowBean(MF_2_ID);
		messageFlow2.setSource((IInteractionNodeBean) lowerParticipantNodes.get(1));
		messageFlow2.setTarget((IInteractionNodeBean) upperParticipantNodes.get(1));
		
		MF_3_ID = createUniqueId();
		MessageFlowBean messageFlow3 = new MessageFlowBean(MF_3_ID);
		messageFlow3.setSource((IInteractionNodeBean) lowerParticipantNodes.get(2));
		messageFlow3.setTarget((IInteractionNodeBean) upperParticipantNodes.get(1));
		
		result.add(messageFlow1);
		result.add(messageFlow2);
		result.add(messageFlow3);
		
		return result;
	}


	private static String createUniqueId(){
		return IdGenerator.createUniqueId();
	}
}
