/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.IArtifactBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.IAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.ITextAnnotationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.artifact.TextAnnotationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;


public class CollaborationBean extends BaseElementBean implements ICollaborationBean{
	
	private String name;
	private List<IParticipantBean> participants;
	private List<IMessageFlowBean> messageFlows;
	private List<IArtifactBean> artifacts;
	private boolean closed;
	private IDefinitionsBean parentDefinitions;
	
	private List<IMessageBean> messages;
	
	public CollaborationBean(){
		this(IdGenerator.createUniqueId());
	}
	
	public CollaborationBean(String id){
		super(id);
		participants = new ArrayList<IParticipantBean>();
        messageFlows = new ArrayList<IMessageFlowBean>();
        artifacts = new ArrayList<IArtifactBean>();
        messages = new ArrayList<IMessageBean>();
		closed = false;
	}
	
	public void setMessages(List<IMessageBean> messages) {
		this.messages = messages;
	}
	
	public void addArtifact(IArtifactBean a){
	    if (artifacts.contains(a)==false) artifacts.add(a);
	}
	
	public void removeArtifact(IArtifactBean a){
        artifacts.remove(a);
    }
	
	public void addParticipant(IParticipantBean participant){
		if (participants.contains(participant)==false){
			participant.setParentCollaborationBean(this);
			participants.add(participant);
			if (getParentDefinitions()!=null) getParentDefinitions().addProcess(participant.getProcess());
		}
	}
	
	public void addMessageFlow(IMessageFlowBean m){
		if (messageFlows.contains(m)==false) messageFlows.add(m);
	}
	
	public void removeParticipant(IParticipantBean Participant){
		if(participants!=null){
			participants.remove(Participant);
		}
	}
	
	public void removeMessageFlow(IMessageFlowBean mf){
		if(messageFlows!=null){
			messageFlows.remove(mf);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public List<IParticipantBean> getParticipants() {
		return participants;
	}
	public void setParticipants(List<IParticipantBean> Participants) {
		this.participants = Participants;
	}
	public List<IMessageFlowBean> getMessageFlows() {
		return messageFlows;
	}
	public void setMessageFlows(List<IMessageFlowBean> messageFlows) {
		this.messageFlows = messageFlows;
	}
	public boolean isClosed() {
		return closed;
	}
	public void setClosed(boolean isClosed) {
		this.closed = isClosed;
	}
	public List<IFlowElementBean> getFlowNodes(){
		List<IFlowElementBean> result = null;
		if(participants!=null && participants.size()!=0){
			result = new ArrayList<IFlowElementBean>();
			for(IParticipantBean Participant : participants){
				if(Participant.getProcess()!=null){
					result.addAll(Participant.getProcess().getFlowNodes());
				}
			}
		}
		return result;
	}
	public IFlowElementBean getFlowNode(String id){
		if(participants!=null && participants.size()!=0){
			for(IParticipantBean Participant : participants){
				if(Participant.getProcess()!=null){
					IFlowElementBean node = searchNodeById(Participant.getProcess().getFlowNodes(),id);
					if(node!=null){
						return node;
					}
				}
			}
		}
		return null;
	}

	private IFlowElementBean searchNodeById(List<? extends IFlowElementBean> flowNodes,String id) {
		if(flowNodes!=null){
			int i = 0;
			boolean found = false;
			while(i<flowNodes.size() && !found){
				IFlowElementBean node = flowNodes.get(i);
				if(node.getId().equals(id)){
					return node;
				}
				else{
					i++;
				}
			}
		}
		return null;
	}
    public List<IArtifactBean> getArtifacts() {
        return artifacts;
    }
    public void setArtifacts(List<IArtifactBean> artifacts) {
        this.artifacts = artifacts;
    }
    @Override
    public List<IAssociationBean> getAssociations() {
        List<IAssociationBean> res = new ArrayList<IAssociationBean>();
        for(IArtifactBean a : artifacts){
            if(a instanceof IAssociationBean){
                res.add((IAssociationBean)a);
            }
        }
        return res;
    }
    @Override
    public List<ITextAnnotationBean> getTextAnnotations() {
        List<ITextAnnotationBean> res = new ArrayList<ITextAnnotationBean>();
        for(IArtifactBean a : artifacts){
            if(a instanceof TextAnnotationBean){
                res.add((TextAnnotationBean)a);
            }
        }
        return res;
    }
    @Override
    public IDefinitionsBean getParentDefinitions() {
        return parentDefinitions;
    }
    @Override
    public void setParentDefinitions(IDefinitionsBean defs) {
        this.parentDefinitions = defs;
    }
    
	public IParticipantBean getParticipantByProcess(IProcessBean process){
		
		for(IParticipantBean p:participants){
			if (p.getProcess()!=null){
				if (p.getProcess().equals(process)){
					return p;
				}
			}
		}
		
		return null;
	}

	@Override
	public void addMessage(IMessageBean message) {
		if (messages.contains(message)==false) messages.add(message);
	}

	@Override
	public List<IMessageBean> getMessages() {
		return messages;
	}
}
