/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.geasywsdl.domain.api.IDefinitions;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ImportType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IWSDLImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.ImportBean;

public class WSDLImportBean extends ImportBean implements IWSDLImportBean {

    private Set<IInterfaceBean> interfaces;

    private Set<IItemDefinitionBean> itemDefinitions;

    private IDefinitions wsdlDefinitions;

    protected WSDLImportBean() {
        super();
        interfaces = new HashSet<IInterfaceBean>();
        itemDefinitions = new HashSet<IItemDefinitionBean>();
    }

    public WSDLImportBean(INamespaceDeclaration nsdeclaration, IDefinitions wsdlDefinitions) {
        super(nsdeclaration);
        this.wsdlDefinitions = wsdlDefinitions;
        interfaces = new HashSet<IInterfaceBean>();
        itemDefinitions = new HashSet<IItemDefinitionBean>();
    }

    @Override
    public String getImportType() {
        return ImportType.WSDL1_1.getValue();
    }

    public Set<IInterfaceBean> getInterfaces() {
        return interfaces;
    }

    public IInterfaceBean getInterfaceByName(String name) {
        for (IInterfaceBean itf : interfaces) {
            if (itf.getName().equals(name)) {
                return itf;
            }
        }
        return null;
    }

    public Set<IOperationBean> getOperations() {
        Set<IOperationBean> res = new HashSet<IOperationBean>();
        for (IInterfaceBean itf : interfaces) {
            res.addAll(itf.getOperations());
        }
        return res;
    }

    public IOperationBean getOperationByName(String name) {
        for (IInterfaceBean itf : interfaces) {
            for (IOperationBean op : itf.getOperations()) {
                if (op.getName().equals(name)) {
                    return op;
                }
            }
        }
        return null;
    }

    public Set<IMessageBean> getMessages() {
        Set<IMessageBean> res = new HashSet<IMessageBean>();
        for (IOperationBean op : getOperations()) {
            res.add(op.getMessageIn());
            if (op.getMessageOut() != null) {
                res.add(op.getMessageOut());
            }
        }
        return res;
    }

    public Set<IErrorBean> getErrors() {
        Set<IErrorBean> res = new HashSet<IErrorBean>();
        for (IOperationBean op : getOperations()) {
            if (op.getErrors() != null) {
                res.addAll(op.getErrors());
            }
        }
        return res;
    }

    public IMessageBean getMessageByName(String name) {
        for (IInterfaceBean itf : interfaces) {
            for (IOperationBean op : itf.getOperations()) {
                if (op.getMessageIn().getName().equals(name)) {
                    return op.getMessageIn();
                }
                if (op.getMessageOut() != null && op.getMessageOut().getName().equals(name)) {
                    return op.getMessageOut();
                }
            }
        }
        return null;
    }

    @Override
    public IDefinitions getWSDLDefinitions() {
        return wsdlDefinitions;
    }

    @Override
    public Set<IItemDefinitionBean> getItemDefinitions() {
        return itemDefinitions;
    }

    public void setInterfaces(Set<IInterfaceBean> arrayList) {
        this.interfaces = arrayList;
    }

    public void setItemDefinitions(Set<IItemDefinitionBean> itemDefinitions) {
        this.itemDefinitions = itemDefinitions;
    }

}
