/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IAssignmentBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IItemAwareElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;


public class DataAssociationBean extends BaseElementBean implements IDataAssociationBean {

	private List<IAssignmentBean> assignements;
	private List<IItemAwareElementBean> sources;
	private IItemAwareElementBean target;
	private IExpressionBean transformation;
	
	private IItemDefinitionBean sourceItem;
	
	private IItemDefinitionBean targetItem;
	
	
	public DataAssociationBean(String id){
		super(id);
		assignements = new ArrayList<IAssignmentBean>();
		sources = new ArrayList<IItemAwareElementBean>();
	}
	
	public DataAssociationBean(){
		this(IdGenerator.createUniqueId());
	}
	
	public void addAssignement(IAssignmentBean a){
		assignements.add(a);
	}
	
	public void removeAssignment(IAssignmentBean a){
		assignements.remove(a);
	}
	
	public void addSource(IItemAwareElementBean a){
		sources.add(a);
	}
	
	public void removeSource(IItemAwareElementBean a){
		sources.remove(a);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IAssignmentBean> getAssignements() {
		return assignements;
	}
	public void setAssignements(List<IAssignmentBean> assignements) {
		this.assignements = assignements;
	}
	public List<IItemAwareElementBean> getSources() {
		return sources;
	}
	public void setSources(List<IItemAwareElementBean> sources) {
		this.sources = sources;
	}
	public IItemAwareElementBean getTarget() {
		return target;
	}
	public void setTarget(IItemAwareElementBean target) {
		this.target = target;
	}
    public IExpressionBean getTransformation() {
        return transformation;
    }
    public void setTransformation(IExpressionBean transformation) {
        this.transformation = transformation;
    }

	@Override
	public IItemDefinitionBean getSourceItem() {
		return sourceItem;
	}

	@Override
	public IItemDefinitionBean getTargetItem() {
		return targetItem;
	}

	@Override
	public void setSourceItem(IItemDefinitionBean item) {
		this.sourceItem = item;
	}

	@Override
	public void setTargetItem(IItemDefinitionBean item) {
		this.targetItem = item;
	}
	
}
