/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IItemAwareElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;

public abstract class ThrowEventBean extends EventBean implements IThrowEventBean {

    private List<IEventDefinitionBean> results;
    private List<IDataAssociationBean> dataInputAssociations;
    private List<IDataInputBean> dataInputs;
    private Set<IItemAwareElementBean> incomingItemAwareElements;

    public ThrowEventBean(String id) {
        super(id);
        results = new ArrayList<IEventDefinitionBean>();
        dataInputs = new ArrayList<IDataInputBean>();
        dataInputAssociations = new ArrayList<IDataAssociationBean>();
        incomingItemAwareElements = new HashSet<IItemAwareElementBean>();
    }

    protected ThrowEventBean() {
        super();
        results = new ArrayList<IEventDefinitionBean>();
        dataInputs = new ArrayList<IDataInputBean>();
        dataInputAssociations = new ArrayList<IDataAssociationBean>();
        incomingItemAwareElements = new HashSet<IItemAwareElementBean>();
    }

    public void addResult(IEventDefinitionBean edt) {
        if(!results.contains(edt)) {
            results.add(edt);
        }
    }

    public void removeResult(IEventDefinitionBean e) {
        results.remove(e);
    }

    public void addDataInput(IDataInputBean d) {
    	if(!dataInputs.contains(d)) {
    		dataInputs.add(d);
    	}
    }

    public void removeDataInput(IDataInputBean d) {
        dataInputs.remove(d);
    }

    public void addDataInputAssociation(IDataAssociationBean d) {
    	if(!dataInputAssociations.contains(d)) {
    		dataInputAssociations.add(d);
    	}
    }

    public void removeDataInputAssociation(IDataAssociationBean d) {
        dataInputAssociations.remove(d);
    }
    
    @Override
	public void addDataInput(IItemAwareElementBean source,IDataInputBean target) {
		this.incomingItemAwareElements.add(source);
		
		this.addDataInput(target);
		
		if (this.getProcess()!=null){
			//if its a dataObject add it to current process
			if (source instanceof IDataObjectBean){
				IDataObjectBean dataObject = (IDataObjectBean) source;
				this.getProcess().addDataObject(dataObject);
			//if its a dataInput/dataOuput add it to current processes ioSpecification				
			}else if (source instanceof IDataInputBean){
				IDataInputBean dinput = (IDataInputBean) source;
				this.getProcess().getIoSpecification().addDataInput(dinput);
			}else if(source instanceof IDataOutputBean){
				IDataOutputBean doutput = (IDataOutputBean) source;
				this.getProcess().getIoSpecification().addDataOutput(doutput);
			}
		}
	}

    //////////////////////////////////////////
    /// /////
    /// GETTERS AND SETTERS /////
    /// /////
    //////////////////////////////////////////
    public List<IEventDefinitionBean> getResults() {
        return results;
    }
    public void setResults(List<IEventDefinitionBean> results) {
        this.results = results;
    }
    public List<IDataInputBean> getDataInputs() {
        return dataInputs;
    }
    public void setDataInputs(List<IDataInputBean> dataInputs) {
        this.dataInputs = dataInputs;
    }
    public List<IDataAssociationBean> getDataInputAssociations() {
        return dataInputAssociations;
    }
    public void setDataInputAssociations(List<IDataAssociationBean> dataInputAssociations) {
        this.dataInputAssociations = dataInputAssociations;
    }
	public Set<IItemAwareElementBean> getIncomingItemAwareElements() {
		return incomingItemAwareElements;
	}
	public void setIncomingItemAwareElements(
			Set<IItemAwareElementBean> incomingItemAwareElements) {
		this.incomingItemAwareElements = incomingItemAwareElements;
	}
    
}
