/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.IExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;



public class ExclusiveGatewayBean extends GatewayBean implements IExclusiveGatewayBean {

	private ISequenceFlowBean defaultSequenceFlow;
	
	public ExclusiveGatewayBean(String id){
		super(id);
		this.setIncomingActivities(null);
		this.setOutgoingActivities(null);
		this.setDefaultSequenceFlow(null);
	}
	
	public ExclusiveGatewayBean(){
		this(IdGenerator.createUniqueId());
	}

	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
    @Override
    public ISequenceFlowBean getDefaultSequenceFlow() {
        return defaultSequenceFlow;
    }

    @Override
    public void setDefaultSequenceFlow(ISequenceFlowBean default_) {
        this.defaultSequenceFlow = default_;
    }
	
}
