/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.IInteractionNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

public class CompleteExampleGenerator {
	
	
	public static String COLLABORATION_ID;
	
	public static String UPPER_Participant_ID;
	public static String UPPER_LANE_ID;
	public static String UPPER_LANE_EL_1_ID;
	public static String UPPER_LANE_EL_2_ID;
	public static String UPPER_LANE_EL_3_ID;
	public static String UPPER_LANE_EL_4_ID;
	public static String UPPER_LANE_EL_5_ID;
	public static String UPPER_LANE_EL_6_ID;
	public static String UPPER_LANE_EL_7_ID;
	public static String UPPER_LANE_EL_8_ID;
	public static String UPPER_LANE_SF_1_ID;
	public static String UPPER_LANE_SF_2_ID;
	public static String UPPER_LANE_SF_3_ID;
	public static String UPPER_LANE_SF_4_ID;
	public static String UPPER_LANE_SF_5_ID;
	public static String UPPER_LANE_SF_6_ID;
	public static String UPPER_LANE_SF_7_ID;
	public static String UPPER_LANE_SF_8_ID;
	//LOWER LANE IDS
	public static String LOWER_Participant_ID;
	public static String LOWER_LANE_1_ID;
	public static String LOWER_LANE_EL_1_ID;
	public static String LOWER_LANE_EL_2_ID;
	public static String LOWER_LANE_EL_3_ID;
	public static String LOWER_LANE_EL_4_ID;
	public static String LOWER_LANE_EL_5_ID;
	public static String LOWER_LANE_EL_6_ID;
	public static String LOWER_LANE_SF_0_ID;
	public static String LOWER_LANE_SF_1_ID;
	public static String LOWER_LANE_SF_2_ID;
	public static String LOWER_LANE_SF_3_ID;
	public static String LOWER_LANE_SF_4_ID;
	public static String LOWER_LANE_SF_5_ID;
	public static String LOWER_LANE_SF_6_ID;
	public static String LOWER_LANE_2_ID;
	public static String LOWER_LANE_2_EL_ID;
	//MESSAGE FLOWS ID
	public static String MF_1_ID;
	

	private static FlowNodeBean MFsource;
	private static FlowNodeBean MFtarget;
	private static SequenceFlowBean incomingSF;
	private static SequenceFlowBean outgoingSF;
	
	
	
	public static DefinitionsBean getExample(){
		DefinitionsBean result = new DefinitionsBean(createUniqueId());
		
		result.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/documentWriting/definition");
		result.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
		result.setExpressionLanguage("http://www.w3.org/1999/XPath");
		
		result.addCollaboration(buildCollaboration(result));
		
		return result;
	}


	private static CollaborationBean buildCollaboration(DefinitionsBean globalResult) {
		COLLABORATION_ID = createUniqueId();
		CollaborationBean result = new CollaborationBean(COLLABORATION_ID);
		result.setName("DocumentWriting");
		result.addParticipant(buildUpperParticipant(globalResult));
		result.addParticipant(buildLowerParticipant(globalResult));
		result.setMessageFlows(buildMessageFlows());
		return result;
	}


	private static ParticipantBean buildUpperParticipant(DefinitionsBean globalResult) {
		UPPER_Participant_ID = createUniqueId();
		ParticipantBean result = new ParticipantBean(UPPER_Participant_ID);
		result.setName("Document initiator");

		result.setDocumentation("Participant who initiates the document.");
		
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(result.getName().replace(" ","")+"Process");
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildUpperLane(process,globalResult));
		
		return result;
	}


	private static LaneBean buildUpperLane(ProcessBean process, DefinitionsBean globalResult) {
		UPPER_LANE_ID = createUniqueId();
		LaneBean result = new LaneBean(UPPER_LANE_ID);
		result.setName("Initiator");
		
		//NODES
		UPPER_LANE_EL_1_ID = createUniqueId();
		StartEventBean startEvent = new StartEventBean(UPPER_LANE_EL_1_ID);
		startEvent.setName("Start");
		process.addStartEvent(startEvent);
		result.addStartEvent(startEvent);
		
		UPPER_LANE_EL_2_ID = createUniqueId();
		TaskBean task1 = new TaskBean(UPPER_LANE_EL_2_ID);
		task1.setName("Initialize \r\n Process");
		process.addTask(task1);
		result.addTask(task1);
		
		UPPER_LANE_EL_3_ID = createUniqueId();
		ParallelGatewayBean gateway1 = new ParallelGatewayBean(UPPER_LANE_EL_3_ID);
		gateway1.setName("Work Distribution");
		result.addGateway(gateway1);
		process.addGateway(gateway1);
		
		UPPER_LANE_EL_4_ID = createUniqueId();
		TaskBean task2 = new TaskBean(UPPER_LANE_EL_4_ID);
		task2.setName("Create \r\n Template");
		result.addTask(task2);
		process.addTask(task2);
		
		UPPER_LANE_EL_5_ID = createUniqueId();
		TaskBean task3 = new TaskBean(UPPER_LANE_EL_5_ID);
		task3.setName("Find Writer");
		result.addTask(task3);
		process.addTask(task3);
		
		UPPER_LANE_EL_6_ID = createUniqueId();
		ParallelGatewayBean gateway2 = new ParallelGatewayBean(UPPER_LANE_EL_6_ID);
		gateway2.setName("Work Aggregation");
		result.addGateway(gateway2);
		process.addGateway(gateway2);
		
		UPPER_LANE_EL_7_ID = createUniqueId();
		SendTaskBean task4 = new SendTaskBean(UPPER_LANE_EL_7_ID);
		task4.setName("Send \r\n Template");
		result.addTask(task4);
		process.addTask(task4);
		
		UPPER_LANE_EL_8_ID = createUniqueId();
		EndEventBean endEvent = new EndEventBean(UPPER_LANE_EL_8_ID);
		EventDefinitionBean ed3 = new MessageEventDefinitionBean(createUniqueId());
		endEvent.addResult(ed3);
		globalResult.addEventDefinition(ed3);
		endEvent.setName("Send To Writer");
		result.addEndEvent(endEvent);
		process.addEndEvent(endEvent);
		MFsource = endEvent;
		

		//Sequence Flows
		UPPER_LANE_SF_1_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(UPPER_LANE_SF_1_ID);
		sf1.setSourceNode(startEvent);
		sf1.setTargetNode(task1);
		process.addSequenceFlow(sf1);
		
		UPPER_LANE_SF_2_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(UPPER_LANE_SF_2_ID);
		sf2.setSourceNode(task1);
		sf2.setTargetNode(gateway1);
		process.addSequenceFlow(sf2);
		
		UPPER_LANE_SF_3_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(UPPER_LANE_SF_3_ID);
		sf3.setSourceNode(gateway1);
		sf3.setTargetNode(task2);
		process.addSequenceFlow(sf3);
		
		UPPER_LANE_SF_4_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(UPPER_LANE_SF_4_ID);
		sf4.setSourceNode(gateway1);
		sf4.setTargetNode(task3);
		process.addSequenceFlow(sf4);
		
		UPPER_LANE_SF_5_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(UPPER_LANE_SF_5_ID);
		sf5.setSourceNode(task2);
		sf5.setTargetNode(gateway2);
		process.addSequenceFlow(sf5);
		
		UPPER_LANE_SF_6_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(UPPER_LANE_SF_6_ID);
		sf6.setSourceNode(task3);
		sf6.setTargetNode(gateway2);
		process.addSequenceFlow(sf6);
		
		UPPER_LANE_SF_7_ID = createUniqueId();
		SequenceFlowBean sf7 = new SequenceFlowBean(UPPER_LANE_SF_7_ID);
		sf7.setSourceNode(gateway2);
		sf7.setTargetNode(task4);
		process.addSequenceFlow(sf7);
		
		UPPER_LANE_SF_8_ID = createUniqueId();
		SequenceFlowBean sf8 = new SequenceFlowBean(UPPER_LANE_SF_8_ID);
		sf8.setSourceNode(task4);
		sf8.setTargetNode(endEvent);
		process.addSequenceFlow(sf8);
		
		return result;
	}

	
	
	private static ParticipantBean buildLowerParticipant(DefinitionsBean globalResult) {
		LOWER_Participant_ID = createUniqueId();
		ParticipantBean result = new ParticipantBean(LOWER_Participant_ID);
		result.setName("Document Writer");
		
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(result.getName().replace(" ","")+"Process");
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildLowerLane1(process,globalResult));
		laneSet.addLane(buildLowerLane2(process));
		return result;
	}
	

	private static LaneBean buildLowerLane1(ProcessBean process, DefinitionsBean globalResult) {
		LOWER_LANE_1_ID = createUniqueId();
		LaneBean result = new LaneBean(LOWER_LANE_1_ID);
		result.setName("Writer");
		
		//NODES
		LOWER_LANE_EL_1_ID = createUniqueId();
		StartEventBean startEvent = new StartEventBean(LOWER_LANE_EL_1_ID);
		startEvent.setName("Template \r\n reception");
		EventDefinitionBean ed = new MessageEventDefinitionBean(createUniqueId());
		startEvent.addTrigger(ed);
		globalResult.addEventDefinition(ed);
		result.addStartEvent(startEvent);
		process.addStartEvent(startEvent);
		MFtarget = startEvent;
		
		LOWER_LANE_EL_2_ID = createUniqueId();
		ReceiveTaskBean task1 = new ReceiveTaskBean(LOWER_LANE_EL_2_ID);
		task1.setName("Receive \r\n template");
		result.addTask(task1);
		process.addTask(task1);

		LOWER_LANE_EL_3_ID = createUniqueId();
		ServiceTaskBean task2 = new ServiceTaskBean(LOWER_LANE_EL_3_ID);
		task2.setName("Write \r\n Document");
		result.addTask(task2);
		process.addTask(task2);
		
		LOWER_LANE_EL_4_ID = createUniqueId();
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(LOWER_LANE_EL_4_ID);
		result.addGateway(gateway);
		process.addGateway(gateway);
		
		LOWER_LANE_EL_5_ID = createUniqueId();
		TaskBean task4 = new TaskBean(LOWER_LANE_EL_5_ID);
		task4.setName("End edition");
		result.addTask(task4);
		process.addTask(task4);
		
		LOWER_LANE_EL_6_ID = createUniqueId();
		EndEventBean endEvent1 = new EndEventBean(LOWER_LANE_EL_6_ID);
		endEvent1.setName("Document Ready"); 
		result.addEndEvent(endEvent1);
		process.addEndEvent(endEvent1);
		
		
		//Sequence Flows
		LOWER_LANE_SF_0_ID = createUniqueId();
		SequenceFlowBean sf = new SequenceFlowBean(LOWER_LANE_SF_0_ID);
		sf.setSourceNode(startEvent);
		sf.setTargetNode(task1);
		process.addSequenceFlow(sf);
		
		LOWER_LANE_SF_1_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(LOWER_LANE_SF_1_ID);
		sf1.setSourceNode(task1);
		sf1.setTargetNode(task2);
		process.addSequenceFlow(sf1);
		
		LOWER_LANE_SF_2_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(LOWER_LANE_SF_2_ID);
		sf2.setSourceNode(task2);
		sf2.setTargetNode(gateway);
		process.addSequenceFlow(sf2);
		
		LOWER_LANE_SF_3_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(LOWER_LANE_SF_3_ID);
		sf3.setSourceNode(gateway);
		//sf3.setTargetNode(task3);
		incomingSF = sf3;
		ExpressionBean exp = new ExpressionBean(createUniqueId());
		exp.setContent("Mistakes Exists");
		sf3.setExpression(exp);
		process.addSequenceFlow(sf3);
		
		LOWER_LANE_SF_4_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(LOWER_LANE_SF_4_ID);
		sf4.setSourceNode(gateway);
		sf4.setTargetNode(task4);
		ExpressionBean exp2 = new ExpressionBean(createUniqueId());
		exp2.setContent("No Mistakes");
		sf4.setExpression(exp2);
		process.addSequenceFlow(sf4);
		
		LOWER_LANE_SF_5_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(LOWER_LANE_SF_5_ID);
		//sf5.setSourceNode(task3);
		outgoingSF = sf5;
		sf5.setTargetNode(endEvent1);
		process.addSequenceFlow(sf5);
		
		LOWER_LANE_SF_6_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(LOWER_LANE_SF_6_ID);
		sf6.setSourceNode(task4);
		sf6.setTargetNode(endEvent1);
		process.addSequenceFlow(sf6);
		
		
		return result;
	}
	
	
	
	private static LaneBean buildLowerLane2(ProcessBean process) {
		LOWER_LANE_2_ID = createUniqueId();
		LaneBean result = new LaneBean(LOWER_LANE_2_ID);
		result.setName("ReWriter");
		
		LOWER_LANE_2_EL_ID = createUniqueId();
		ServiceTaskBean task = new ServiceTaskBean(LOWER_LANE_2_EL_ID);
		task.setName("Refactor \r\n Document");
		result.addTask(task);
		process.addTask(task);
		
		incomingSF.setTargetNode(task);
		outgoingSF.setSourceNode(task);
		
		return result;
	}
	
	
	
	
	private static List<IMessageFlowBean> buildMessageFlows() {
		ArrayList<IMessageFlowBean> result = new ArrayList<IMessageFlowBean>();
		
		MF_1_ID = createUniqueId();
		MessageFlowBean messageFlow1 = new MessageFlowBean(MF_1_ID);
		messageFlow1.setSource((IInteractionNodeBean) MFsource);
		messageFlow1.setTarget((IInteractionNodeBean) MFtarget);
		
		result.add(messageFlow1);
		
		return result;
	}


	private static String createUniqueId(){
		return IdGenerator.createUniqueId();
	}

}
