/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.AttributeExtension;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;

public abstract class BaseElementBean extends BPMNElementBean implements IBaseElementBean {
	
	private String id;
	private INamespaceDeclaration nsDeclaration;
	private List<ObjectExtension> objectExtensions;
	private List<AttributeExtension> attributeExtensions;
	
	protected BaseElementBean(){
		super();
		objectExtensions = new ArrayList<ObjectExtension>();
		attributeExtensions = new ArrayList<AttributeExtension>();
	}

	public BaseElementBean(String id){
		this();
		this.id = id;
	}
	
	@Override
	public boolean equals(Object obj) {
	    if(obj==null) return false;
		BaseElementBean elToCompare = (BaseElementBean) obj;
		if (elToCompare.getId().equals(id)){
			return true;
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return id.hashCode();
	}

	public void addObjectExtension(ObjectExtension obj){
		this.objectExtensions.add(obj);
	}
	
	public void removeObjectExtension(ObjectExtension obj){
		this.objectExtensions.remove(obj);
	}
	
	public void addAttributeExtension(AttributeExtension att){
		for(AttributeExtension a : attributeExtensions){
			if(a.hasSameErasure(att)){
				String qname = a.getAttributeQNameNS()+":"+a.getAttributeQNameLocalPart();
				throw new IllegalArgumentException(
						"This element ("+id+") already has an attribute with QName "+qname+".");
			}
		}
		this.attributeExtensions.add(att);
	}
	
	public void removeAttributeExtension(AttributeExtension att){
		this.attributeExtensions.remove(att);
	}
	
	public AttributeExtension getAttributeExtension(String ns, String lp){
		for(AttributeExtension att : attributeExtensions){
			if(att.getAttributeQNameNS().equals(ns) && att.getAttributeQNameLocalPart().equals(lp)){
				return att;
			}
		}
		return null;
	}
	
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public List<ObjectExtension> getObjectExtensions() {
		return objectExtensions;
	}

	public void setObjectExtensions(List<ObjectExtension> objectExtensions) {
		this.objectExtensions = objectExtensions;
	}

	public List<AttributeExtension> getAttributeExtensions() {
		return attributeExtensions;
	}

	public void setAttributeExtensions(
			List<AttributeExtension> attributeExtensions) {
		this.attributeExtensions = attributeExtensions;
	}
	
	public INamespaceDeclaration getNSDeclaration() {
	    return this.nsDeclaration;
	}
	
	public void setNSDeclaration(INamespaceDeclaration nsd) {
	    this.nsDeclaration = nsd;
	}
}
