/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;

public abstract class ThrowEventBean extends EventBean implements IThrowEventBean {

    private List<IEventDefinitionBean> results;

    private List<IDataInputBean> dataInputs;

    private List<IDataInputAssociationBean> dataInputAssociations;

    public ThrowEventBean(String id) {
        super(id);
        results = new ArrayList<IEventDefinitionBean>();
        dataInputs = new ArrayList<IDataInputBean>();
        dataInputAssociations = new ArrayList<IDataInputAssociationBean>();
    }

    protected ThrowEventBean() {
        super();
        results = new ArrayList<IEventDefinitionBean>();
        dataInputs = new ArrayList<IDataInputBean>();
        dataInputAssociations = new ArrayList<IDataInputAssociationBean>();
    }

    public void addResult(IEventDefinitionBean edt) {
        results.add(edt);
    }

    public void removeResult(IEventDefinitionBean e) {
        results.remove(e);
    }

    public void addDataInput(IDataInputBean d) {
        dataInputs.add(d);
    }

    public void removeDataInput(IDataInputBean d) {
        dataInputs.remove(d);
    }

    public void addDataInputAssociation(IDataInputAssociationBean d) {
        dataInputAssociations.add(d);
    }

    public void removeDataInputAssociation(IDataInputAssociationBean d) {
        dataInputAssociations.remove(d);
    }

    // //////////////////////////////////////////
    // /// /////
    // /// GETTERS AND SETTERS /////
    // /// /////
    // //////////////////////////////////////////
    public List<IEventDefinitionBean> getResults() {
        return results;
    }

    public void setResults(List<IEventDefinitionBean> results) {
        this.results = results;
    }

    public List<IDataInputBean> getDataInputs() {
        return dataInputs;
    }

    public void setDataInputs(List<IDataInputBean> dataInputs) {
        this.dataInputs = dataInputs;
    }

    public List<IDataInputAssociationBean> getDataInputAssociations() {
        return dataInputAssociations;
    }

    public void setDataInputAssociations(List<IDataInputAssociationBean> dataInputAssociations) {
        this.dataInputAssociations = dataInputAssociations;
    }

}
