/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer;

import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class ImportedElementsTest {
    @Test
    public void testImportedInterface() throws BPMNException, XmlObjectWriteException {
        DefinitionsBean importedDefs = new DefinitionsBean("importedDefs");
        importedDefs.setTargetNamespace("TNS");
        NamespaceDeclaration nsd = new NamespaceDeclaration("prefix", importedDefs.getTargetNamespace());
        BPMN20ImportBean impt = new BPMN20ImportBean((INamespaceDeclaration)nsd, (IDefinitionsBean)importedDefs);
        InterfaceBean itfb = new InterfaceBean("itfb");
        itfb.setNSDeclaration((INamespaceDeclaration)nsd);
        importedDefs.addInterface((IInterfaceBean)itfb);
        DefinitionsBean mainDefs = new DefinitionsBean("mainDefs");
        mainDefs.addImport((IImportBean)impt);
        ChoreographyBean chor = new ChoreographyBean("chor");
        mainDefs.addChoreography((IChoreographyBean)chor);
        ParticipantBean participant = new ParticipantBean("participant");
        participant.addInterface((IInterfaceBean)itfb);
        chor.addParticipant((IParticipantBean)participant);
        Definitions defs = ClientToServer.adapt((DefinitionsBean)mainDefs);
        Assert.assertTrue((defs.getInterfaces() == null || defs.getInterfaces().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)defs.hasImport());
        Assert.assertEquals((int)1, (int)defs.getImports().length);
        Import i = defs.getImports()[0];
        Assert.assertTrue((boolean)i.isBPMN20Import());
        Participant p = defs.getChoreographies()[0].getParticipant()[0];
        Assert.assertNotNull((Object)p);
        Assert.assertTrue((boolean)p.hasInterfaceRef());
        Assert.assertEquals((int)1, (int)p.getInterfaceRef().length);
        QName ref = p.getInterfaceRef()[0];
        Assert.assertEquals((String)nsd.getURI(), (String)ref.getNamespaceURI());
        Assert.assertEquals((String)nsd.getPrefix(), (String)ref.getPrefix());
        Assert.assertEquals((String)itfb.getId(), (String)ref.getLocalPart());
    }

    @Test
    public void testQNameAdaption() throws BPMNException {
        DefinitionsBean defs = new DefinitionsBean("defs");
        defs.setTargetNamespace("TNS");
        NamespaceDeclaration nsd = new NamespaceDeclaration("prefix", "tns");
        ImportBean i = new ImportBean((INamespaceDeclaration)nsd);
        defs.addImport((IImportBean)i);
        String id1 = "id1";
        String ref1 = "ref1";
        ItemDefinitionBean i1 = new ItemDefinitionBean(id1);
        i1.setStructureRef(nsd.getPrefix() + ":" + ref1);
        defs.addItemDefinition((IItemDefinitionBean)i1);
        String id2 = "id2";
        String ref2 = "ref2";
        ItemDefinitionBean i2 = new ItemDefinitionBean(id2);
        i2.setStructureRef(new QName(nsd.getURI(), ref2).toString());
        defs.addItemDefinition((IItemDefinitionBean)i2);
        String id3 = "id3";
        String ref3 = "{plop}ref3";
        ItemDefinitionBean i3 = new ItemDefinitionBean(id3);
        i3.setStructureRef(ref3);
        defs.addItemDefinition((IItemDefinitionBean)i3);
        String id4 = "id4";
        String ref4 = "ref4";
        ItemDefinitionBean i4 = new ItemDefinitionBean(id4);
        i4.setStructureRef(ref4);
        defs.addItemDefinition((IItemDefinitionBean)i4);
        Definitions d = ClientToServer.adapt((DefinitionsBean)defs);
        Assert.assertEquals((int)4, (int)d.getItemDefinitions().length);
        for (ItemDefinition item : d.getItemDefinitions()) {
            if (item.getId().equals(id1)) {
                Assert.assertNotNull((Object)item);
                Assert.assertNotNull((Object)item.getStructureRef());
                Assert.assertEquals((Object)new QName(nsd.getURI(), ref1), (Object)item.getStructureRef());
                continue;
            }
            if (item.getId().equals(id2)) {
                Assert.assertNotNull((Object)item);
                Assert.assertNotNull((Object)item.getStructureRef());
                Assert.assertEquals((Object)new QName(nsd.getURI(), ref2), (Object)item.getStructureRef());
                continue;
            }
            if (item.getId().equals(id3)) {
                Assert.assertNotNull((Object)item);
                Assert.assertNotNull((Object)item.getStructureRef());
                Assert.assertEquals((Object)QName.valueOf(ref3), (Object)item.getStructureRef());
                continue;
            }
            if (item.getId().equals(id4)) {
                Assert.assertNotNull((Object)item);
                Assert.assertNotNull((Object)item.getStructureRef());
                Assert.assertEquals((Object)QName.valueOf(ref4), (Object)item.getStructureRef());
                continue;
            }
            Assert.fail((String)"Unknown item definition");
        }
    }
}

