/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.extension;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.BPELExampleGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBinder;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBindingManager;
import com.ebmwebsourcing.petalsbpm.server.service.extension.FakeExtensionBinder;
import com.ebmwebsourcing.petalsbpm.server.service.extension.WSDLInputBean;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Assert;
import org.junit.Test;

public class ExtensionBindingManagerTest {
    private String testId1;
    private String testId2;
    private String testId3;
    private String testId4;

    @Test
    public void testExtensionBindingManager() {
        ExtensionBindingManager manager = new ExtensionBindingManager();
        List l = manager.getBinders();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((int)1, (int)l.size());
        Assert.assertEquals(FakeExtensionBinder.class, ((ExtensionBinder)l.get(0)).getClass());
    }

    @Test
    public void testObjectExtension() throws BPMNException, XPathExpressionException {
        DefinitionsBean defsBefore = this.getDefinitionsWithObjectExtensions();
        IBaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defsBefore, this.testId1);
        Assert.assertNotNull((Object)b1.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b1.getObjectExtensions().size());
        ObjectExtension o1 = (ObjectExtension)b1.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o1.getClass());
        Assert.assertEquals((String)"name1", (String)((WSDLInputBean)o1).getName());
        IBaseElementBean b2 = DefinitionsHelper.getInstance().getElementById(defsBefore, this.testId2);
        Assert.assertNotNull((Object)b2.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b2.getObjectExtensions().size());
        ObjectExtension o2 = (ObjectExtension)b2.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o2.getClass());
        Assert.assertEquals((String)"name2", (String)((WSDLInputBean)o2).getName());
        IBaseElementBean b3 = DefinitionsHelper.getInstance().getElementById(defsBefore, this.testId3);
        Assert.assertNotNull((Object)b3.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b3.getObjectExtensions().size());
        ObjectExtension o3 = (ObjectExtension)b3.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o3.getClass());
        Assert.assertEquals((String)"name3", (String)((WSDLInputBean)o3).getName());
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
        XmlObjectXPathEvaluator xpathEvaluator = defs.getXmlContext().createXPathEvaluator();
        BaseElement b12 = (BaseElement)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId1 + "']", BaseElement.class);
        Assert.assertNotNull((Object)b12);
        Assert.assertTrue((boolean)b12.hasExtensionElements());
        ExtensionElements ee1 = b12.getExtensionElements();
        Assert.assertNotNull((Object)ee1.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee1.getAnyXmlObjects().length);
        XmlObject o12 = ee1.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o12 instanceof Input));
        Assert.assertEquals((String)"name1", (String)((Input)o12).getName());
        BaseElement b22 = (BaseElement)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId2 + "']", BaseElement.class);
        Assert.assertNotNull((Object)b22);
        Assert.assertTrue((boolean)b22.hasExtensionElements());
        ExtensionElements ee2 = b22.getExtensionElements();
        Assert.assertNotNull((Object)ee2.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee2.getAnyXmlObjects().length);
        XmlObject o22 = ee2.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o22 instanceof Input));
        Assert.assertEquals((String)"name2", (String)((Input)o22).getName());
        BaseElement b32 = (BaseElement)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId3 + "']", BaseElement.class);
        Assert.assertNotNull((Object)b32);
        Assert.assertTrue((boolean)b32.hasExtensionElements());
        ExtensionElements ee3 = b32.getExtensionElements();
        Assert.assertNotNull((Object)ee3.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee3.getAnyXmlObjects().length);
        XmlObject o32 = ee3.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o32 instanceof Input));
        Assert.assertEquals((String)"name3", (String)((Input)o32).getName());
        DefinitionsBean defsAfter = ServerToClient.adapt((Definitions)defs);
        IBaseElementBean b13 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId1);
        Assert.assertNotNull((Object)b13.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b13.getObjectExtensions().size());
        o12 = (ObjectExtension)b13.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o12.getClass());
        Assert.assertEquals((String)"name1", (String)((WSDLInputBean)o12).getName());
        b22 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId2);
        Assert.assertNotNull((Object)b22.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b22.getObjectExtensions().size());
        ObjectExtension o23 = (ObjectExtension)b22.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o23.getClass());
        Assert.assertEquals((String)"name2", (String)((WSDLInputBean)o23).getName());
        IBaseElementBean b33 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId3);
        Assert.assertNotNull((Object)b33.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b33.getObjectExtensions().size());
        ObjectExtension o33 = (ObjectExtension)b33.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o33.getClass());
        Assert.assertEquals((String)"name3", (String)((WSDLInputBean)o33).getName());
    }

    @Test
    public void testUnsupportedObjectExtensionBean() throws XPathExpressionException {
        DefinitionsBean defsBean = this.getDefinitionsWithUnsupportedExtension();
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        XmlObjectXPathEvaluator xpathEvaluator = defs.getXmlContext().createXPathEvaluator();
        BaseElement b1 = (BaseElement)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId4 + "']", BaseElement.class);
        Assert.assertNotNull((Object)b1);
        Assert.assertFalse((boolean)b1.hasExtensionElements());
    }

    @Test
    public void testUnsupportedObjectExtension() throws BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        Definitions defs = (Definitions)context.getXmlObjectFactory().create(Definitions.class);
        Process p = (Process)context.getXmlObjectFactory().create(Process.class);
        defs.addRootElement((RootElement)p);
        ExtensionElements ext = (ExtensionElements)context.getXmlObjectFactory().create(ExtensionElements.class);
        p.setExtensionElements(ext);
        ext.addAnyXmlObject((XmlObject)context.getXmlObjectFactory().create(Output.class));
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        IProcessBean pb = (IProcessBean)defsBean.getProcesses().get(0);
        Assert.assertTrue((pb.getObjectExtensions() == null || pb.getObjectExtensions().isEmpty() ? 1 : 0) != 0);
    }

    private DefinitionsBean getDefinitionsWithObjectExtensions() {
        DefinitionsBean defs = BPELExampleGenerator.getExample();
        this.testId1 = BPELExampleGenerator.LOWER_LANE_ID;
        IBaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defs, this.testId1);
        WSDLInputBean ext1 = new WSDLInputBean("name1");
        b1.addObjectExtension((ObjectExtension)ext1);
        this.testId2 = BPELExampleGenerator.LOWER_LANE_SF_1_ID;
        IBaseElementBean b2 = DefinitionsHelper.getInstance().getElementById(defs, this.testId2);
        WSDLInputBean ext2 = new WSDLInputBean("name2");
        b2.addObjectExtension((ObjectExtension)ext2);
        this.testId3 = BPELExampleGenerator.UPPER_LANE_EL_1_ID;
        IBaseElementBean b3 = DefinitionsHelper.getInstance().getElementById(defs, this.testId3);
        WSDLInputBean ext3 = new WSDLInputBean("name3");
        b3.addObjectExtension((ObjectExtension)ext3);
        return defs;
    }

    private DefinitionsBean getDefinitionsWithUnsupportedExtension() {
        DefinitionsBean defs = MockDefinitionsDB.getSingleExample();
        IBaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defs, MockDefinitionsDB.LOWER_LANE_EL_9_ID);
        WSDLInputBean ext1 = new WSDLInputBean("name1");
        b1.addObjectExtension((ObjectExtension)ext1);
        this.testId4 = MockDefinitionsDB.MF_3_ID;
        IBaseElementBean b = DefinitionsHelper.getInstance().getElementById(defs, this.testId4);
        UnsupportedObjectExtensionBean ext = new UnsupportedObjectExtensionBean();
        b.addObjectExtension((ObjectExtension)ext);
        return defs;
    }

    private class UnsupportedObjectExtensionBean
    implements ObjectExtension {
        private static final long serialVersionUID = 1L;

        private UnsupportedObjectExtensionBean() {
        }
    }
}

