/**
 * petalsbpm-service - BPMN Editor service - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.service.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;


public class ExtensionBindingManager {

	private List<ExtensionBinder> binders;
	
	public ExtensionBindingManager(){
		ServiceLoader<ExtensionBinder> sl = ServiceLoader.load(ExtensionBinder.class);
		Iterator<ExtensionBinder> it = sl.iterator();
		binders = new ArrayList<ExtensionBinder>();
		while(it.hasNext()){
			binders.add(it.next());
		}
	}
	
	
	public XmlObject clientToServer(ObjectExtension ext) {
		for(ExtensionBinder binder : binders){
			if(binder.supportsObjectExtensionBean(ext.getClass())){
				return binder.clientToServer(ext);
			}
		}
		throw new IllegalArgumentException(ext.getClass()+" is not supported by any of the provided extension binders.");
	}
	
	
	public ObjectExtension serverToClient(XmlObject ext) {
		for(ExtensionBinder binder : binders){
			if(binder.supportsXmlObject(ext.getClass())){
				return binder.serverToClient(ext);
			}
		}
		throw new IllegalArgumentException(ext.getClass()+" is not supported by any of the provided extension binders.");
	}

	/**
	 * Does not return the live list
	 * @return A copy of all the found extension binders in the class path
	 */
	public List<ExtensionBinder> getBinders() {
		return new ArrayList<ExtensionBinder>(binders);
	}
	
}
