/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.utils.server;

import com.ebmwebsourcing.petalsbpm.utils.server.ZipHelper;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipException;
import junit.framework.Assert;
import org.junit.Test;

public class ZipHelperTest {
    @Test
    public void testIsZip() throws URISyntaxException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("zipFile.zip");
        File f = new File(url.toURI());
        Assert.assertTrue((boolean)ZipHelper.isZipFile((File)f));
        url = Thread.currentThread().getContextClassLoader().getResource("file");
        f = new File(url.toURI());
        Assert.assertFalse((boolean)ZipHelper.isZipFile((File)f));
    }

    @Test
    public void testUnzip() throws URISyntaxException, ZipException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("zipFile.zip");
        File f = new File(url.toURI());
        File unzipDir = new File("target/unzip");
        unzipDir.mkdirs();
        ZipHelper.unzipFile((File)f, (File)unzipDir);
        Assert.assertTrue((boolean)unzipDir.exists());
        File[] files = unzipDir.listFiles();
        Assert.assertEquals((int)1, (int)files.length);
        File folder = files[0];
        Assert.assertTrue((boolean)folder.isDirectory());
        files = folder.listFiles();
        Assert.assertEquals((int)1, (int)files.length);
        File file = files[0];
        Assert.assertTrue((boolean)file.isFile());
    }
}

