/**
 * petalsbpm-utils - BPMNEditor utils - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.utils.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/**
 * Zip Helper
 * 
 * For handling zip files
 * 
 * @author nfleury
 * 
 */
public class ZipHelper {

	
    public static File createZipFromFolder(String folderLocation, String zipFile) throws IOException{
        try {
            File zip = new File(zipFile);
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));

            zipDir(folderLocation, zos, folderLocation); 
            zos.close(); 
            return zip;
        } catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Couldn't create Zip file:" + zipFile + " from folder "
                    + folderLocation);
        }
    }

    
    private static void zipDir(String dir2zip, ZipOutputStream zos, String initialLocation) throws IOException{
        File zipDir = new File(dir2zip);

        String[] dirList = zipDir.list(); 
        for(int i=0; i<dirList.length; i++){ 
            File f = new File(zipDir, dirList[i]); 
            if(f.isDirectory()){ 
                //if the File object is a directory, call this 
                //function again to add its content recursively 
                String filePath = f.getPath(); 
                zipDir(filePath, zos, initialLocation); 
                //loop again 
                continue; 
            }
            
            ZipEntry anEntry = new ZipEntry(f.getPath().replace(initialLocation, "")); 
            zos.putNextEntry(anEntry); 
            
            FileInputStream fis = new FileInputStream(f); 
            byte[] readBuffer = new byte[2156]; 
            int bytesIn = 0; 
            while((bytesIn = fis.read(readBuffer)) != -1){ 
                zos.write(readBuffer, 0, bytesIn); 
            } 

            fis.close(); 
        }
    }

    
    @SuppressWarnings("unchecked")
    public static void unzipFile(File file, File unzipDir) throws ZipException, IOException {
        FileHelper.cleanDirectory(unzipDir);

        ZipFile zf = new ZipFile(file);
        Enumeration<ZipEntry> entries = (Enumeration<ZipEntry>) zf.entries();

        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();

            InputStream is = zf.getInputStream(ze);
            File f = new File(unzipDir, ze.getName());

            if(ze.isDirectory()) {
                f.mkdirs();
            }
            else if(!f.getParentFile().equals(unzipDir)) {
                f.getParentFile().mkdirs();
            }

            if(!ze.isDirectory()) {
                FileOutputStream out = new FileOutputStream(f);
                byte buf[] = new byte[1024];
                int len;
                while ((len = is.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
            }
            
            is.close();
        }
    }

    
    public static boolean isZipFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream zis = new ZipInputStream(fis);
        return (zis.getNextEntry() != null);
    }

}
