package com.ebmwebsourcing.cep.server;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.xml.XMLEventBean;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;

import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import engine.cep.admin.api.Action;
import engine.cep.admin.api.Action.Fields;

public class EventListener implements UpdateListener {

	private static final Logger LOG = Logger.getLogger(EventListener.class.getName());


	private List<Action> actions = null;
	private String clientAddress;
	private String producerAddress;
	private List<Namespace> nss = new ArrayList<Namespace>();

	private SOAPSender sender = new SOAPSender();
	private DataManagerClientImplSOAP easierGovClient; 

	public EventListener(String clientAddress, String producerAddress, List<Action> actions, List<engine.cep.admin.api.Namespace> nss, DataManagerClientImplSOAP easierGovClient) {
		this.actions = actions;
		this.clientAddress = clientAddress;
		this.producerAddress = producerAddress;
		for(engine.cep.admin.api.Namespace ns: nss) {
			this.nss.add(Namespace.getNamespace(ns.getPrefix(), ns.getNamespace()));
		}
		this.easierGovClient = easierGovClient;
	}

	@Override
	public void update(EventBean[] newEvents, EventBean[] oldEvents) {
		System.out.println("Nikel!!!!!!!!!!!!!! CA MARCHE !!!!!!: " + "new = " + newEvents[0] + " old = " + oldEvents);
		MapEventBean ev = (MapEventBean) newEvents[0];
		System.out.println("ev = " + ev);

		System.out.println("numbers of action: " + actions.size());
		for(Action a: actions) {
			System.out.println("action : " + a);
			if(a.getType().equals("event")) {
				try {
					QName resultEvent = a.getName();

					GetElement request = new GetElement();
					request.setIdElement(resultEvent);
					GetElementResponse response = this.easierGovClient.getElement(request);

					Document doc =  null;
					if(response.getAny() instanceof EJaxbSchema) {
						doc = SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny());
					} else if(response.getAny() instanceof Element) {
						doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
						doc.appendChild(doc.adoptNode((Element) response.getAny()));
					}

					Schema schema = SOAUtil.getInstance().getReader(DefaultFramework.getInstance()).get().readDocument(doc, Schema.class);
					com.ebmwebsourcing.easyschema10.api.element.Element elmt = schema.getElementByName(resultEvent.getLocalPart());
					org.jdom.Element jelmt = XSD2XML.newInstance().generateElement(elmt, schema, null);

					ExpressionEvaluator exp = new ExpressionEvaluator();

					// convert map
					for(engine.cep.admin.api.Action.Fields.Entry e: a.getFields().getEntry()) {
						Map<String, org.jdom.Element> varContext = new HashMap<String, org.jdom.Element>();
						if(e.getKey().indexOf("/") > 0) {
							varContext.put(e.getKey().substring(0, e.getKey().indexOf("/")).replace("$", ""), jelmt);
						} else {
							varContext.put(e.getKey().replace("$", ""), jelmt);
						}

						for(Entry<String, Object> entryProperty: ev.getProperties().entrySet()) {
							//System.out.println("entryProperty.getValue() = " + entryProperty.getValue());
							if(entryProperty.getValue() instanceof XMLEventBean) {
								XMLEventBean bean = (XMLEventBean) entryProperty.getValue();
								//System.out.println("under = " + bean.getUnderlying());
								varContext.put(entryProperty.getKey(), new DOMBuilder().build((Element)bean.getUnderlying()));
							} else if(entryProperty.getValue() instanceof String) {
								String bean = (String) entryProperty.getValue();
								//System.out.println("under = " + bean);
								String buff = "<" + entryProperty.getKey() + ">" + bean + "</" + entryProperty.getKey() + ">";
								Document vardoc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(buff.getBytes()));
								//System.out.println("entryProperty.getKey() = " + entryProperty.getKey());
								varContext.put(entryProperty.getKey(), new DOMBuilder().build(vardoc.getDocumentElement()));
							}
						}

//						System.out.println("varContext = " + varContext);

						Object source = exp.evaluateAsNode(varContext, e.getValue(), nss);
						Object destination = exp.evaluateAsNode(varContext, e.getKey(), nss);

						new CepAssigner().affect(destination, source);
					}
					doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(new XMLOutputter().outputString(jelmt).getBytes()));
					for(QName topicUsed: a.getTopic()) {
						Notify notify = WSNHelper.createNotification(this.clientAddress, this.producerAddress, topicUsed, doc);

						//						System.out.println("************ WAIT 5s that PROCESS BECOMES SUSPENDED");
						//						Thread.sleep(5000);

						
						Document requestResultEvent = SOAPSender.createSOAPMessageRequest(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
						//System.out.println(XMLPrettyPrinter.prettyPrint(requestResultEvent));
						for(String publisher: a.getPublishDestination()) {
							System.out.println("************ SEND COMPLEX EVENT FROM CEP: clientAddress = " + clientAddress + "  -  producerAddress = " + producerAddress + "  -  publisher = " + publisher + "  -  topicUsed = " + topicUsed);
							this.sender.sendSoapRequest(requestResultEvent, publisher, null);
						}
					}
				} catch (Exception e) {
					// do nothing
					e.printStackTrace();
				} 
			} else {
				LOG.severe("Type of action do not taken account: " + a.getType());
			}
		}
	}

}
