/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.cep.server;

import com.ebmwebsourcing.cep.server.Cep;
import com.ebmwebsourcing.cep.server.EventListener;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.UpdateListener;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.SubscriptionsRequired;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@WebService(serviceName="CloudManagementService", portName="CloudManagementSOAPEndpoint", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class CepManagementImpl
implements CloudManagement {
    private static final Logger LOG = Logger.getLogger(CepManagementImpl.class.getName());
    private String cepAddress;
    private Cep.CEP_MODE mode;
    private Integer cpt = 0;
    private boolean first = true;
    private SOAPSender sender = new SOAPSender();
    private String SeaCloud_EndpointAddressToSubscribe = null;
    private DataManagerClientImplSOAP easierGovClient;
    private EPServiceProvider epService = null;

    public CepManagementImpl(String cepAddress) throws CloudManagementException {
        this.cepAddress = cepAddress;
        this.mode = Cep.CEP_MODE.ESPER;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
        Configuration config = new Configuration();
        config.getEngineDefaults().getLogging().setEnableQueryPlan(true);
        config.getEngineDefaults().getLogging().setEnableExecutionDebug(true);
        config.getEngineDefaults().getLogging().setEnableTimerDebug(false);
        this.epService = EPServiceProviderManager.getDefaultProvider((Configuration)config);
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notify(EJaxbNotify notify) {
        LOG.info("Executing operation notify on cep");
        System.out.println(notify);
        Integer n = this.cpt;
        synchronized (n) {
            System.out.println("Hello!!!!");
            Integer n2 = this.cpt;
            Integer n3 = this.cpt = Integer.valueOf(this.cpt + 1);
            try {
                Document event = this.getEventInNotify(notify);
                System.out.println("****** Notify on CEP: \n" + XMLPrettyPrinter.prettyPrint((Document)event));
                this.epService.getEPRuntime().sendEvent((Node)event);
                System.out.println("****** NUMBER OF NOTIFICATION RECEIVED ON CEP:" + this.cpt);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private Document getEventInNotify(EJaxbNotify notify) throws WsnbException {
        Document doc = null;
        try {
            for (EJaxbNotificationMessageHolderType msgh : notify.getNotificationMessage()) {
                Element elmt = (Element)msgh.getMessage().getAny();
                doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode(elmt));
            }
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        return doc;
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters) throws CloudManagementException {
        AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
        try {
            ArrayList<URL> easierGovAdresses = new ArrayList<URL>();
            for (Resource rsc : parameters.getResourcesDescriptor().getResource()) {
                if (!ResourceType.GOVERNANCE.equals((Object)rsc.getType())) continue;
                easierGovAdresses.add(new URL(rsc.getAddress()));
            }
            URL easierGovAdress = null;
            if (easierGovAdresses.size() > 0) {
                easierGovAdress = new URL(((URL)easierGovAdresses.get(0)).toString().replace("eventManager", "dataManager"));
                System.out.println("easierGovAdress = " + easierGovAdress);
                this.easierGovClient = new DataManagerClientImplSOAP(easierGovAdress.toString());
                System.out.println("Governance is now connected to cep");
            }
        }
        catch (MalformedURLException e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public String addStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        AddStatementResponseWithActions res = new AddStatementResponseWithActions();
        try {
            this.cpt = 0;
            System.out.println("RECIEVED CEP RULE TO DEPLOY ON CEP");
            SubscriptionsRequired subscriptionsRequired = parameters.getSubscriptionsRequired();
            List entries = subscriptionsRequired.getEntry();
            System.out.println("entries: " + entries);
            if (this.easierGovClient != null) {
                for (SubscriptionsRequired.Entry entry : entries) {
                    if (entry.getCorrespondingEvent() == null) continue;
                    GetElement request = new GetElement();
                    request.setIdElement(entry.getCorrespondingEvent());
                    GetElementResponse response = this.easierGovClient.getElement(request);
                    String bufferSchema = null;
                    if (response.getAny() instanceof EJaxbSchema) {
                        bufferSchema = XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny()));
                    } else if (response.getAny() instanceof Element) {
                        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                        doc.appendChild(doc.adoptNode((Element)response.getAny()));
                        bufferSchema = XMLPrettyPrinter.prettyPrint((Document)doc);
                    }
                    String schemaText = XMLPrettyPrinter.prettyPrint((Document)DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(bufferSchema.getBytes())));
                    System.out.println("******** CEP number of subscription required: " + entries.size());
                    ConfigurationEventTypeXMLDOM eventcfg = new ConfigurationEventTypeXMLDOM();
                    eventcfg.setXPathPropertyExpr(true);
                    System.out.println("******** CEP entry.getCorrespondingEvent() = " + entry.getCorrespondingEvent());
                    eventcfg.setRootElementName(entry.getCorrespondingEvent().getLocalPart());
                    eventcfg.setSchemaText(schemaText);
                    this.epService.getEPAdministrator().getConfiguration().addEventType(entry.getCorrespondingEvent().getLocalPart(), eventcfg);
                }
            } else {
                LOG.warning("Governance is not connected to CEP !!!");
            }
            EPStatement statement = this.epService.getEPAdministrator().createEPL(parameters.getStatement());
            statement.addListener((UpdateListener)new EventListener(this.SeaCloud_EndpointAddressToSubscribe, this.cepAddress, parameters.getAction(), parameters.getNamespaceOfEventTypes(), this.easierGovClient));
            System.out.println("statement = " + statement);
            for (SubscriptionsRequired.Entry entry : entries) {
                QName topicUsed = entry.getTopic();
                System.out.println("topicUsed: " + topicUsed);
                this.SeaCloud_EndpointAddressToSubscribe = entry.getEndpointAddressToSubscribe();
                AdminManagementClientSOAP clientSubscribe = new AdminManagementClientSOAP(this.SeaCloud_EndpointAddressToSubscribe);
                Subscribe payload = WSNHelper.createSubscription((String)this.cepAddress, (QName)topicUsed, (QName[])new QName[]{entry.getCorrespondingEvent()});
                Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
                if (topicUsed != null) {
                    EJaxbSubscribe not = (EJaxbSubscribe)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);
                    doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)not);
                }
                System.out.println("CEP SUBSCRIBE on topic: " + topicUsed);
                System.out.println("CEP SUBSCRIBE :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                EJaxbSubscribeResponse response = clientSubscribe.subscribe(doc);
                System.out.println("CEP SUBSCRIBE ON " + topicUsed + " => OK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public BindResponse bind(Bind arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String deleteStatement(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String expose(QName arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName arg0) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        throw new UnsupportedOperationException();
    }

    public String getStatementById(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ProxifyResponse proxify(Proxify arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe arg0) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        throw new UnsupportedOperationException();
    }

    public String updateStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public void addResourcesDescriptorFromURL(String descriptorURL, boolean eraseOlders) throws CloudManagementException {
    }

    public String ping() {
        return "I am alive!!!";
    }
}

