/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.ela.alert.ui;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import easybox.note.protocol.alerting.common.petalslink.com._1.EJaxbAlertNoteDefinitionType;
import easybox.oasis.names.tc.emergency.cap._1.EJaxbAlert;
import easybox.oasis.names.tc.emergency.cap._1.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AlertNotificationConsumerUI
implements NotificationConsumerDecorator {
    private boolean ui = false;
    private List<EJaxbNotify> notifies = new ArrayList<EJaxbNotify>();

    public AlertNotificationConsumerUI(boolean ui) {
        this.ui = ui;
    }

    public void notify(EJaxbNotify notify) {
        try {
            this.notifies.add(notify);
            String msg = "ELA ALERT RECEIVED:\n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify));
            System.out.println(msg);
            System.out.println("ELA ALERT UI: " + this.ui);
            Object payload = ((EJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage().getAny();
            System.out.println("ELA ALERT PAYLOAD: " + payload.getClass());
            String m = "ELA ALERT RECEIVED:\n";
            if (payload instanceof Element) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode((Element)payload));
                EJaxbAlert alert = (EJaxbAlert)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbAlert.class);
                m = m + "MsgType = " + alert.getMsgType() + "\n";
                Document docNote = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(alert.getNote().getBytes()));
                EJaxbAlertNoteDefinitionType note = (EJaxbAlertNoteDefinitionType)SOAJAXBContext.getInstance().marshallAnyType(docNote, EJaxbAlertNoteDefinitionType.class);
                if (note != null) {
                    m = m + "initiator = " + note.getInitiatorIdentifier().getEndpointName() + "\n" + "responder = " + note.getResponderIdentifier().getEndpointName() + "\n" + "message = " + note.getMessage() + "\n";
                }
            }
            System.out.println("m = " + m);
            if (this.ui) {
                JOptionPane.showMessageDialog(null, m, "ELA Alert", 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<EJaxbNotify> getNotifications() {
        return this.notifies;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class, ObjectFactory.class, easybox.note.protocol.alerting.common.petalslink.com._1.ObjectFactory.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

