package com.ebmwebsourcing.eval;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class EvalLogger {

	private static Logger logger = Logger.getLogger (EvalLogger.class.getSimpleName());

	private Handler socketHandler;

	private Handler fileHandler;

	private static EvalLogger INSTANCE;

	public enum Direction {
		Entry,
		Exit;
	}

	private EvalLogger()  {
		createSocketHandler();
		createFileHandler(); 
	}

	private void createFileHandler() {
		try {
			fileHandler = new FileHandler("eval-log-%u.log");
			fileHandler.setLevel (Level.FINEST);
			fileHandler.setFormatter(new LogFormatter());
			logger.addHandler (socketHandler);
		} catch (Exception e) {
			System.err.println("Warning!!! Impossible to connect FileHandler: " + e.getMessage());
		}
	}

	private void createSocketHandler() {
		try {
			socketHandler = new SocketHandler ("localhost", 5000);
			//set handler log level
			socketHandler.setLevel (Level.FINEST);
			socketHandler.setFormatter(new LogFormatter());
			//set logger log level
			logger.setLevel(Level.FINEST);
			//add socket handler to sent our logs to log server..

		} catch (IOException e) {
			System.err.println("Warning!!! Impossible to connect SocketHandler: " + e.getMessage());
		}
	}

	public static EvalLogger getInstance() {
		if(INSTANCE == null) {
			INSTANCE = new EvalLogger();
		}
		return INSTANCE;
	}


	public synchronized void log(Level level, String msg) {
		System.out.println("socketHandler: " + socketHandler);
		if(socketHandler != null) {
			logger.addHandler (socketHandler);
		}
		if(fileHandler != null)  {
			logger.addHandler(fileHandler);
		}
		logger.log(level, msg);
		if(socketHandler != null) {
			logger.removeHandler (socketHandler);
		}
		if(fileHandler != null)  {
			logger.removeHandler(fileHandler);
		}
	}

	public void logNotif(Class clazz, String component, Direction direction, EJaxbNotify notify) {
		logNotif(clazz, component, direction, notify, null);
	}

	public void logNotif(Class clazz, String component, Direction direction, EJaxbNotify notify, List<String> correlatedIds) {
		try {
			String eventID = getEventIdInNotify(notify);
			if(eventID == null) {
				eventID = setEventIdInNotify(notify);
			}
			String msg = clazz.getName() + " " + component + " " + direction + " " + eventID + " ";
			if(correlatedIds != null) {
				for(String correlatedId: correlatedIds) {
					msg = msg + correlatedId + " ";
				}
			}
			this.log(Level.INFO, msg);
		} catch(Throwable e) {
			// do nothing
			e.printStackTrace();
		}
	}


	private String setEventIdInNotify(EJaxbNotify notify) {
		String eventId = "http://events.event-processing.org/ids/" + UUID.randomUUID().toString();
		Document emissionDate = createEventID(eventId);
		notify.getAny().add(emissionDate.getDocumentElement());
		return eventId;
	}

	public static String getEventIdInNotify(EJaxbNotify notify) {
		String eventId = null;
		for(Object obj: notify.getAny()) {
			if(obj instanceof Element) {
				Element elmt = (Element)obj;
				if(elmt.getNamespaceURI().equals("http://wwww.soceda.org/ids") && 
						elmt.getLocalName().equals("eventID")) {
					eventId = elmt.getAttribute("id");
					break;
				}
			}
		}
		return eventId;
	}

	private Document createEventID(String eventID) {
		Document doc = null;
		try {
			doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			Element id = doc.createElementNS("http://wwww.soceda.org/ids", "eventID");
			id.setPrefix("id");
			//	id.setNodeValue(eventID);
			id.setAttribute("id", eventID);
			doc.appendChild(id);
		} catch(Exception e) {
			// do nothing
			e.printStackTrace();
		}
		return doc;
	}

}