/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eval.launcher;

import com.ebmwebsourcing.eval.launcher.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static String CONFIG = "config.properties";

    public ConfigurationImpl() throws Exception {
        this.properties.put("host", "localhost");
        this.properties.put("port", "9000");
        this.loadConfigurationFile();
    }

    public ConfigurationImpl(Map<String, String> data) throws Exception {
        this.properties = data;
    }

    public ConfigurationImpl(String host, int port) throws Exception {
        this.properties.put("host", String.valueOf(host));
        this.properties.put("port", String.valueOf(port));
    }

    private void loadConfigurationFile() throws Exception {
        Properties props = new Properties();
        File f = new File(CONFIG);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading config from " + f.getAbsoluteFile());
        }
        FileInputStream is = null;
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new Exception(e);
            }
        }
        if (is != null) {
            try {
                props.load(is);
                for (Object k : props.keySet()) {
                    this.properties.put(k.toString().trim(), props.get(k).toString().trim());
                }
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        } else {
            log.warning("No configuration file found...");
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public static String getCONFIG() {
        return CONFIG;
    }

    public static void setCONFIG(String config) {
        CONFIG = config;
    }

    @Override
    public Integer getPort() {
        return Integer.valueOf(this.getProperties().get("port"));
    }

    @Override
    public String getHost() {
        return String.valueOf(this.getProperties().get("host"));
    }

    @Override
    public void setHost(String host) {
        this.properties.put("host", String.valueOf(host));
    }

    @Override
    public void setPort(int port) {
        this.properties.put("port", String.valueOf(port));
    }
}

