/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eval.launcher;

import com.ebmwebsourcing.eval.EvalLoggerServer;
import com.ebmwebsourcing.eval.launcher.ConfigurationImpl;
import com.ebmwebsourcing.eval.launcher.Launcher;
import com.ebmwebsourcing.eval.launcher.util.CommandReader;
import com.ebmwebsourcing.eval.launcher.util.Locker;
import com.ebmwebsourcing.eval.launcher.util.SystemExitHook;
import java.io.File;
import java.util.ArrayList;

public class EvalLoggerLauncher
implements Launcher {
    protected static final String START_COMMAND = "start";
    protected static final String SHUTDOWN_COMMAND = "shutdown";
    protected static final String VERSION_COMMAND = "version";
    protected String banner = " -----------------------------------------------------------\n|                                                           |\n|                          Eval Logger Server                |\n|                                                           |\n -----------------------------------------------------------\n";
    protected EvalLoggerServer server;
    protected SystemExitHook systemExitHook;
    protected final Locker locker = new Locker(new File("."));

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("Eval Logger is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("Eval Logger is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.server);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new Exception("Can not start the Eval Logger server, remove lock file from Eval Logger root path or stop server");
        }
        this.locker.lock();
        ConfigurationImpl conf = new ConfigurationImpl();
        String host = conf.getHost();
        int port = conf.getPort();
        if (host == null || port <= 0) {
            throw new Exception("Wrong host or port parameters!!!");
        }
        this.server = new EvalLoggerServer(port);
        System.out.println("Eval Logger Server start at: http://" + host + ":" + port);
        this.server.start();
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the Eval Logger container");
        System.out.println(" -shutdowm               shutdown the Eval Logger container");
        System.out.println(" -version                get the Eval Logger container version");
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(EvalLoggerServer node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }
}

