/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package com.ebmwebsourcing.eventcloud.mocked.server;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;


/**
 * This class was generated by Apache CXF 2.5.0-easy
 * 2012-01-17T15:16:49.423+01:00
 * Generated source version: 2.5.0-easy
 * 
 */

@javax.jws.WebService(serviceName = "CloudManagementService", portName = "CloudManagementSOAPEndpoint", targetNamespace = "http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation = "wsdl/SeaCloud.wsdl", endpointInterface = "seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class EventCloudMockedManagementImpl implements CloudManagement {

	private static final Logger LOG = Logger.getLogger(EventCloudMockedManagementImpl.class.getName());

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private String eventcloudAddress;
	private int cpt = 0;
	private boolean ui = false;

	private SOAPSender sender = new SOAPSender();
	private Map<TopicKey, List<URI>> clientsMap = new HashMap<TopicKey, List<URI>>();

	private List<AbstractFilter> filters = new ArrayList<AbstractFilter>();

	private List<URI> clientsForReport = new ArrayList<URI>();

	public EventCloudMockedManagementImpl(String cepAddress, boolean ui) throws CloudManagementException {
		this.eventcloudAddress = cepAddress;
		this.ui = ui;
		ServiceLoader<AbstractFilter> serviceLoader = ServiceLoader.load(AbstractFilter.class);
		serviceLoader.reload();
		Iterator<AbstractFilter> commandsIterator = serviceLoader.iterator();
		while (commandsIterator.hasNext()) {
			AbstractFilter command = commandsIterator.next();
			filters.add(command);
			LOG.info("SPI: Filter found: \"" + command + "\" is created");
		}
	}

	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault,
			org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault,
			org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault,
			org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault,
			org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault,
			org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidFilterFault,
			org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault {

		EJaxbSubscribeResponse response = new EJaxbSubscribeResponse();
		try {
			URI clientEPR = URI.create(subscribeRequest.getConsumerReference().getAddress().getValue());
			System.out.println("Event cloud (subscribe) =>\n" + XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(subscribeRequest)));
			System.out.println("Event cloud (subscribe) => client EPR: " + clientEPR);

			System.out.println("Event cloud (subscribe) => filter: " + subscribeRequest.getFilter().getAny());
			EJaxbTopicExpressionType texp = null;

			for(Object obj: subscribeRequest.getFilter().getAny()) {
				if(obj instanceof EJaxbTopicExpressionType) {
					texp = (EJaxbTopicExpressionType) obj;
					break;
				} else if(obj instanceof JAXBElement) {
					JAXBElement jelmt = (JAXBElement) obj;
					if(jelmt.getValue() instanceof EJaxbTopicExpressionType) {
						texp = (EJaxbTopicExpressionType) jelmt.getValue();
						break;
					}
				}
			}

			System.out.println("Event cloud (subscribe) => texp = " + texp);
			QName topic = WSNHelper.getQNameInSimpleTopicExpression(texp);
			List<QName> msgs = WSNHelper.getMessages(WSNHelper.getMessageContentInFilter(subscribeRequest.getFilter()));
			System.out.println("Event cloud (subscribe) => topic: " + topic);
			System.out.println("Event cloud (subscribe) => msgs: " + msgs);

			// FOR EASIERBSM
			if(topic.toString().equals("{http://www.petalslink.org/resources/event/1.0}CreationResourcesTopic")) {
				// IGNORE
				System.out.println("Event cloud (subscribe) => IGNORE: topic: {http://www.petalslink.org/resources/event/1.0}CreationResourcesTopic");
			} else if(topic.toString().equals("{http://www.petalslink.org/rawreport/1.0}RawReportTopic")) {
				if(!clientsForReport.contains(clientEPR)) {
					clientsForReport.add(clientEPR);
				}
				System.out.println("Event cloud (subscribe) on RawReportTopic. Add Bsm client: " + clientsForReport);
			} else {

				List<URI> clientURIS = this.clientsMap.get(topic);
				if(clientURIS == null) {
					clientURIS = new ArrayList<URI>();
				}

				System.out.println("Event cloud (subscribe) => find topic: " + TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))));
				if(TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))).size() > 0) {
					for(TopicKey key: TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])))) {
						clientURIS = this.clientsMap.get(key);
						if(!clientURIS.contains(clientEPR)) {
							clientURIS.add(clientEPR);
						}
					}
				} else {
					clientURIS.add(clientEPR);
					this.clientsMap.put(new TopicKey(topic, msgs), clientURIS);
				}

				System.out.println("Event cloud (subscribe) => clients added: " + this.clientsMap);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new InvalidTopicExpressionFault(e.getMessage(), e);
		} 
		return response;
	}

	public synchronized void notify(EJaxbNotify notify) {
		LOG.info("Executing operation notify on event cloud");
		System.out.println(notify);
		try {
			System.out.println("Event cloud (notify) => notify received: \n"
					+ XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance()
							.unmarshallAnyElement(notify)));

			for(EJaxbNotificationMessageHolderType h: notify.getNotificationMessage()) {
				QName topic = WSNHelper.getQNameInSimpleTopicExpression(h.getTopic());
				List<QName> msgs = new ArrayList<QName>();
				Element elmt = (Element) h.getMessage().getAny();
				QName msg = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
				msgs.add(msg);

				System.out.println("Event cloud (notify) => this.clientMap: " + this.clientsMap);
				System.out.println("Event cloud (notify) => topic = " + topic);
				System.out.println("Event cloud (notify) => msgs = " + msgs);

				List<TopicKey> keys = TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])));
				System.out.println("Event cloud (notify) => keys = " + keys);
				for(TopicKey key: keys) {
					List<URI> clients = this.clientsMap.get(key);
					System.out.println("Event cloud (notify) => clients found: " + clients);

					System.out.println("gggggggggggggggggggggggggggggggg UI: " + ui);
					
					if(clients != null) {
						for(URI uri: clients) {
							if(filters.isEmpty()) {
								System.out.println("gggggggggggggggggggggggggggggggg NO FILTER!!!!");
								Document request = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(notify));
								System.out.println("Event cloud (notify) => Send notification to " + uri.toString());
								System.out.println("Event cloud (notify) => notif to send:\n" + XMLPrettyPrinter.prettyPrint(request));
								sender.sendSoapRequest(request, uri.toString(), "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
							} else {
								System.out.println("gggggggggggggggggggggggggggggggg FILTERS" + filters);
								
								for(AbstractFilter filter: filters) {
									if(filter.filter(uri.toString(), h.getProducerReference().getAddress().getValue().toString(), ui)) {
										Document request = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(notify));
										System.out.println("Event cloud (notify) => Send notification to " + uri.toString());
										System.out.println("Event cloud (notify) => notif to send:\n" + XMLPrettyPrinter.prettyPrint(request));
										sender.sendSoapRequest(request, uri.toString(), "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
									} else {
										LOG.warning("notification produced by " + h.getProducerReference().getAddress().toString() + " and at destination to " + uri.toString() + " has been rejected by social filter");
									}
								}
							}
							
							// send report to monitoring
							sendReportToMonitoring(this.clientsForReport, uri, elmt, notify);
						}
						
					}
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void sendReportToMonitoring(List<URI> clientsBSM,
			URI consumer, Element eventPayload, EJaxbNotify notify) {
		try {
			ReportList reports = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(ReportList.class);

			String subscriptionAddress = consumer.toString();

			
			String producerAddress = null;
			if(notify.getNotificationMessage().get(0).getProducerReference() != null) {
				producerAddress = notify.getNotificationMessage().get(0).getProducerReference().getAddress().getValue();
			} else {
				producerAddress = "unknown";
			}
			// create raw report
			Report report = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Report.class);
			report.setExchangeId("-1");
			report.setEndpointName(subscriptionAddress);
			report.setOperationName("notify");
			report.setInterfaceQName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
			report.setServiceQName(null);
			report.setConsumerEndpointAddress(subscriptionAddress);
			report.setProviderEndpointAddress(producerAddress);
			report.setDateInGMT(Calendar.getInstance().getTime());
			report.setTimeStamp(TimeStampType.t1);
			report.setContentLength(XMLPrettyPrinter.prettyPrint(eventPayload).length());
			reports.addReport(report);

			// create notification containing rawreport
			Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			SOAUtil.getInstance().getWriter(DefaultFramework.getInstance()).get().writeDocument(reports, notifPayload);
			QName topicUsed = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic","tns");
			String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";

			// send notification containing rawreport
			for(URI currentConsumerEdp: clientsBSM) {
				final Notify notifyWithRawReport = WSNHelper.createNotification(currentConsumerEdp.toString(), this.eventcloudAddress, topicUsed, notifPayload);
				final Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notifyWithRawReport);
				this.sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(request), currentConsumerEdp.toString(), null);
				System.out.println("Notification with RawReport sended to " + currentConsumerEdp.toString() + "\nNotification raw report:\n" + XMLPrettyPrinter.prettyPrint(request));
			}
		} catch(Exception e) {
			// do nothing
			e.printStackTrace();
		}
	}



	@Override
	public AddResourcesDescriptorResponse addResourcesDescriptor(
			AddResourcesDescriptor arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public String addStatement(String arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public AddStatementResponseWithActions addStatementWithActions(
			AddStatementWithActions parameters) throws CloudManagementException {
		AddStatementResponseWithActions res = new AddStatementResponseWithActions();
		throw new UnsupportedOperationException();
	}

	@Override
	public BindResponse bind(Bind arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public String deleteStatement(String arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws CloudManagementException {
		try {
			System.out.println("--------- DEPLOY");
			System.out.println("--------- DEPLOY SOCIAL RELATION: " + parameters.getMainResource().getFileURI());
			List<URL> rscs = new ArrayList<URL>();
			rscs.add(new URL(parameters.getMainResource().getFileURI()));
			for(EJaxbDescriptorType rsc: parameters.getResources()) {
				rscs.add(new URL(rsc.getFileURI()));
			}
			System.out.println("--------- DEPLOY SOCIAL RELATION: " + rscs);
			
			for(AbstractFilter filter: filters) {
				filter.init(rscs);
			}

			EJaxbDeployResponse resp = new EJaxbDeployResponse();
			return resp;
		} catch (Exception e) {
			throw new CloudManagementException(e.getMessage(), e);
		}
	}

	@Override
	public String expose(QName arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(QName arg0)
			throws ResourceUnavailableFault, ResourceUnknownFault,
			InvalidResourcePropertyQNameFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getStatementById(String arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public ListAllStatementsResponse listAllStatements(ListAllStatements arg0)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public ProxifyResponse proxify(Proxify arg0)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe arg0)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public String updateStatement(String arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}


}
