package com.ebmwebsourcing.eventcloud.mocked.server;


import javax.xml.namespace.QName;

import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;

/**
 * This class was generated by Apache CXF 2.2.9
 * Tue Feb 01 10:31:55 CET 2011
 * Generated source version: 2.2.9
 * 
 */

public class EventCloudMocked implements Server {
	
    private com.ebmwebsourcing.easycommons.research.util.cxf.Server ep = null;

    private Object implementation = null;

    private Definitions def = null;
    
    private Port endpoint = null;
    
    private Service service = null;
    
    private boolean isStopped = false;

    public EventCloudMocked(String address, boolean ui) throws CloudManagementException {
        this.implementation = new EventCloudMockedManagementImpl(address, ui);
        ep = CXFHelper.getService(address, this.implementation.getClass(), this.implementation);
        System.out.println("***************** EventCloudMocked Started on : " + address);
        try {
            if(ep.getWsdlLocation() != null) {
                def = SOAUtil.getInstance().getReader(DefaultFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(ep.getWsdlLocation()), Definitions.class);
                service = def.getServiceByName(ep.getServiceQName().getLocalPart());
                endpoint = service.getPorts()[0];
                Address addr = SoapBindingHelper.getAddress(endpoint);
                addr.setLocation(address);
                SoapBindingHelper.setAddress(endpoint, addr);
            } else {
                throw new CloudManagementException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
        } catch (XmlObjectReadException e) {
            throw new CloudManagementException(e.getMessage(), e);
        }
    }


    @Override
    public String getAddress() {
        return ep.getAddress();
    }

    @Override
    public void start() {
        ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
        isStopped = false;
    }

    @Override
    public void stop() {
        ep.stop();
        isStopped = true;
    }


	@Override
	public QName getServiceQName() {
		return this.service.inferQName();
	}


	@Override
	public String getWsdlLocation() {
		return def.getXmlObjectBaseURI().toString();
	}


	@Override
	public boolean isStopped() {
		// TODO Auto-generated method stub
		return false;
	}


}

