/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.server;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMockedManagementImpl;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import javax.xml.namespace.QName;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class EventCloudMocked
implements Server {
    private Server ep = null;
    private Object implementation = null;
    private Definitions def = null;
    private Port endpoint = null;
    private Service service = null;
    private boolean isStopped = false;

    public EventCloudMocked(String address, boolean ui) throws CloudManagementException {
        this.implementation = new EventCloudMockedManagementImpl(address, ui);
        this.ep = CXFHelper.getService((String)address, this.implementation.getClass(), (Object)this.implementation);
        System.out.println("***************** EventCloudMocked Started on : " + address);
        try {
            if (this.ep.getWsdlLocation() == null) {
                throw new CloudManagementException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
            this.def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)DefaultFramework.getInstance()).get()).readDocument(Thread.currentThread().getContextClassLoader().getResource(this.ep.getWsdlLocation()), Definitions.class);
            this.service = this.def.getServiceByName(this.ep.getServiceQName().getLocalPart());
            this.endpoint = this.service.getPorts()[0];
            Address addr = SoapBindingHelper.getAddress((Port)this.endpoint);
            addr.setLocation(address);
            SoapBindingHelper.setAddress((Port)this.endpoint, (Address)addr);
        }
        catch (XmlObjectReadException e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public String getAddress() {
        return this.ep.getAddress();
    }

    public void start() {
        this.ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
        this.isStopped = false;
    }

    public void stop() {
        this.ep.stop();
        this.isStopped = true;
    }

    public QName getServiceQName() {
        return this.service.inferQName();
    }

    public String getWsdlLocation() {
        return this.def.getXmlObjectBaseURI().toString();
    }

    public boolean isStopped() {
        return false;
    }
}

