/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package com.ebmwebsourcing.seacloud.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.cxf.helpers.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easierbsm.admin.client.impl.BSMAdminClientImplSOAP;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEsperDeployerModule;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEtalisDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.ESBDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.MonitoringDeployerModule;
import com.ebmwebsourcing.seacloud.model.CEPModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.ESBPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModuleMocked;
import com.petalslink.data_api._1.PublishSchemaFromDOM;
import com.petalslink.data_api._1.PublishSchemaFromDOMResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;

import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsb;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import fr.inria.eventcloud.deployment.cli.launchers.EventCloudsManagementServiceDeployer;


/**
 * This class was generated by Apache CXF 2.5.0-easy
 * 2012-01-17T15:16:49.423+01:00 Generated source version: 2.5.0-easy
 * 
 */

@javax.jws.WebService(serviceName = "CloudManagementService", portName = "CloudManagementSOAPEndpoint", targetNamespace = "http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation = "wsdl/SeaCloud.wsdl", endpointInterface = "seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class SeaCloudManagementImpl implements CloudManagement {

	private static final Logger LOG = Logger.getLogger(SeaCloudManagementImpl.class.getName());

	private static final String EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME = "eventcloud.activate.loggers";

	private ESBDeployerModule esbDeployer = null;
	private MonitoringDeployerModule bsmDeployer = null;
	private CEPModule cepDeployer = null;
	private PubSubModule esbPubSub = null;
	private PubSubModule eventcloudPubSub = null;
	private SeaCloud.CEP_MODE mode = null;

	private String seaCloudAddress;
	private boolean useCepMock = false;
	private boolean useEventCloudMock = false;

	private List<ResourcesDescriptor> descriptors = new ArrayList<ResourcesDescriptor>();

	private List<URL> eventClouds = new ArrayList<URL>();
	private List<URL> cepEngines = new ArrayList<URL>();
	private List<URL> esbNodes = new ArrayList<URL>();
	private List<URL> monitoring = new ArrayList<URL>();
	private List<URL> easierGovAdresses = new ArrayList<URL>();


	private DataManagerClientImplSOAP dataGovClient = null;
	private EventManagerClientImplSOAP eventGovClient = null;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(engine.cep.admin.api.ObjectFactory.class,
					easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory.class,
					easybox.org.w3._2005._08.addressing.ObjectFactory.class,
					seacloud.petalslink.com.data._1.ObjectFactory.class,
					easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class);
		} catch(Exception e) {
			// do nothing
		}
	}

	public SeaCloudManagementImpl(ResourcesDescriptor descriptor, String seaCloudAddress,
			SeaCloud.CEP_MODE mode, boolean useCepMock, boolean useEventCloudMock)
					throws CloudManagementException {
		this.seaCloudAddress = seaCloudAddress;
		this.useCepMock = useCepMock;
		this.useEventCloudMock = useEventCloudMock;
		this.mode = mode;
		this.setDescriptor(descriptor);
	}

	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault,
			org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault,
			org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault,
			org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault,
			org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault,
			org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidFilterFault,
			org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault {
		EJaxbSubscribeResponse _esbreturn = null;
		LOG.info("Executing operation subscribe on SeaCloud");
		System.out.println(subscribeRequest);
		try {
			LOG.info("Executing subscription on eventcloudPubSub module");
			EJaxbSubscribeResponse _eventCloudreturn = this.eventcloudPubSub.subscribe(subscribeRequest);

			// change consumer address
			// set SeaCloud address in consumerAddress
			subscribeRequest.getConsumerReference().getAddress().setValue(this.seaCloudAddress);

			LOG.info("Executing subscription on esbPubSub module");
			_esbreturn = this.esbPubSub.subscribe(subscribeRequest);

			LOG.info("End of subscription on SeaCloud");
		} catch (RuntimeException e) {
			LOG.severe("Error to subscribe in SeaCloud");
			e.printStackTrace();
			throw e;
		}
		return _esbreturn;
	}

	public void notify(EJaxbNotify notify) {
		LOG.info("Executing operation notify");
		System.out.println(notify);
		try {
			System.out.println("eventCloud class: " + this.eventcloudPubSub.getClass());
			//System.out.println("notify: \n" +
			//		XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(notify)));

			this.eventcloudPubSub.notify(notify);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws CloudManagementException {
		LOG.info("Executing operation deploy");
		System.out.println(parameters);
		EJaxbDeployResponse _return = null;
		LOG.info("Resource to deploy: " + parameters.getMainResource().getFileURI().toString());
		try {

			if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".bpel")) {
				_return = this.esbDeployer.deploy(parameters);
			} else if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".cep")) {
				System.out.println("deploy cep rule");
				Document doc = null;
				doc = extractDocumentFrom(parameters);
				AddStatementWithActions cepRule = SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementWithActions.class);
				this.cepDeployer.addStatementWithActions(cepRule);
				_return = new EJaxbDeployResponse();
			} else if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".soc")) {
				if (useEventCloudMock) {
					System.out.println("************* Use EventCloudPubSubModuleMocked");
					_return = ((EventCloudPubSubModuleMocked)this.eventcloudPubSub).deploy(parameters);
				} else {
					throw new CloudManagementException("TODO: Not implemented => the I3S event cloud should be exposed deploy method to set relation graph!!!");
				}
			} else if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".ela")) {
				_return = this.bsmDeployer.deploy(parameters);
			} else if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".xsd")) {
				System.out.println("deploy xsd schema");
				Document doc = null;
				doc = extractDocumentFrom(parameters);
				PublishSchemaFromDOM request = new PublishSchemaFromDOM();
				request.setAny(doc.getDocumentElement());
				PublishSchemaFromDOMResponse resp = this.getDataGovClient().publishSchemaFromDOM(request);
				_return = new EJaxbDeployResponse();
			} else if(parameters.getMainResource().getFileURI().toString().trim().endsWith(".topns")) {
				System.out.println("deploy topicnamespace");
				Document doc = null;
				doc = extractDocumentFrom(parameters);
				PublishTopicNamespaceFromDOM request = new PublishTopicNamespaceFromDOM();
				request.setTopicNamespace(SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbTopicNamespaceType.class));
				PublishTopicNamespaceFromDOMResponse resp = this.getEventGovClient().publishTopicNamespaceFromDOM(request);
				_return = new EJaxbDeployResponse();
			} else {
				throw new CloudManagementException("Kind of file not supported here: " + parameters.getMainResource().getFileURI().toString()); 
			}
		} catch(Exception e) {
			e.printStackTrace();
			throw new CloudManagementException(e.getMessage(), e);
		}


		return _return;
	}

	public static Document extractDocumentFrom(EJaxbDeploy parameters)
			throws IOException, SAXException, ParserConfigurationException,
			FileNotFoundException, MalformedURLException {
		Document doc;
		if(parameters.getMainResource().getAttachment().getInputStream() != null) {
			doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(parameters.getMainResource().getAttachment().getInputStream());
		} else {
			if(parameters.getMainResource().getFileURI().toString().startsWith(".")) {
				System.out.println("local file detected: " + new File(parameters.getMainResource().getFileURI()).getCanonicalFile());
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new FileInputStream(new File(parameters.getMainResource().getFileURI()).getCanonicalFile()));
			} else {
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new URL(parameters.getMainResource().getFileURI()).openStream());
			}
		}
		return doc;
	}

	public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
			throws org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault,
			org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault,
			org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault {
		LOG.info("Executing operation getResourceProperty");
		System.out.println(getResourcePropertyRequest);
		EJaxbGetResourcePropertyResponse _return = new EJaxbGetResourcePropertyResponse();
		return _return;
	}

	public BindResponse bind(Bind parameters) throws CloudManagementException {
		LOG.info("Executing operation bind");
		System.out.println(parameters);
		BindResponse _return = this.esbDeployer.bind(parameters);
		return _return;

	}

	public String expose(QName serviceName, String endpointName) throws CloudManagementException {
		LOG.info("Executing operation expose");
		System.out.println(serviceName);
		System.out.println(endpointName);
		String _return = this.esbDeployer.expose(serviceName, endpointName);
		return _return;
	}

	public ProxifyResponse proxify(Proxify parameters) throws CloudManagementException {
		LOG.info("Executing operation proxify");
		System.out.println(parameters);
		ProxifyResponse _return = this.esbDeployer.proxify(parameters);
		return _return;
	}

	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
			throws org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault,
			org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault {
		LOG.info("Executing operation unsubscribe");
		System.out.println(unsubscribeRequest);
		EJaxbUnsubscribeResponse _eventCloudreturn = this.eventcloudPubSub.unsubscribe(unsubscribeRequest);
		EJaxbUnsubscribeResponse _esbreturn = this.esbPubSub.unsubscribe(unsubscribeRequest);
		return _esbreturn;
	}

	@Override
	public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters)
			throws CloudManagementException {
		AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
		try {
			if(parameters.isEraseOlders()) {
				eventClouds = new ArrayList<URL>();
				cepEngines = new ArrayList<URL>();
				esbNodes = new ArrayList<URL>();
				monitoring = new ArrayList<URL>();
				easierGovAdresses = new ArrayList<URL>();
				descriptors = new ArrayList<ResourcesDescriptor>();
			}

			for (Resource rsc : parameters.getResourcesDescriptor().getResource()) {
				if (ResourceType.CEP_ENGINE.equals(rsc.getType())) {
					cepEngines.add(new URL(rsc.getAddress()));
				} else if (ResourceType.ESB.equals(rsc.getType())) {
					esbNodes.add(new URL(rsc.getAddress()));
				} else if (ResourceType.EVENT_CLOUD.equals(rsc.getType())) {
					eventClouds.add(new URL(rsc.getAddress()));
				} else if (ResourceType.MONITORING.equals(rsc.getType())) {
					monitoring.add(new URL(rsc.getAddress()));
				} else if (ResourceType.GOVERNANCE.equals(rsc.getType())) {
					easierGovAdresses.add(new URL(rsc.getAddress()));
				}
			}

			this.esbDeployer = new ESBDeployerModule(esbNodes);
			this.bsmDeployer = new MonitoringDeployerModule(monitoring);

			URL easierGovAdress = null;
			if (easierGovAdresses.size() > 0) {
				easierGovAdress = easierGovAdresses.get(0);

				// connect easiergov to easyesb node
				ConnexionManagerClientImplSOAP clientConnectGov = new ConnexionManagerClientImplSOAP(easierGovAdress.toString().replace("eventManager", "connexionManager"));
				for(URL node: this.esbNodes) {
					ConnectToEnvironment request = new ConnectToEnvironment();
					request.setEndpointAddress(node.toString());
					clientConnectGov.connectToEnvironment(request);

					// connect easyesb node to governance
					AdminClientImplSOAP esbClient = new AdminClientImplSOAP(node.toString());
					esbClient.connectToGovernance(easierGovAdress.toString());
				}
			}

			if (mode == SeaCloud.CEP_MODE.ESPER) {
				this.cepDeployer = new CEPEsperDeployerModule(cepEngines, this.seaCloudAddress,
						easierGovAdress);
			} else {
				this.cepDeployer = new CEPEtalisDeployerModule(cepEngines, this.seaCloudAddress,
						easierGovAdress);
			}

			// connect easiergov to dicepe
			this.cepDeployer.addResourcesDescriptor(parameters);

			this.esbPubSub = new ESBPubSubModule(esbNodes);

			if (useEventCloudMock) {
				System.out.println("************* Use EventCloudPubSubModuleMocked");
				this.eventcloudPubSub = new EventCloudPubSubModuleMocked(eventClouds);
			} else {
				System.out.println("************* Use EventCloudPubSubModule");
				this.eventcloudPubSub = new EventCloudPubSubModule(eventClouds);
			}


			// connect easierbsm to eventcloud
			for(URL bsm: this.monitoring) {
				BSMAdminClientImplSOAP bsmclient = new BSMAdminClientImplSOAP(bsm.toString());

				for(URL eventcloud: this.eventClouds) {
					bsmclient.connectToEsb(eventcloud.toString(), false);
				}
			}


			this.descriptors.add(0, parameters.getResourcesDescriptor());

		} catch (Exception e) {
			e.printStackTrace();
			throw new CloudManagementException(e.getMessage(), e);
		}
		return response;
	}

	public List<ResourcesDescriptor> getDescriptors() {
		return descriptors;
	}

	public void setDescriptor(ResourcesDescriptor descriptor) throws CloudManagementException {
		if (descriptor != null) {
			AddResourcesDescriptor request = new AddResourcesDescriptor();
			request.setResourcesDescriptor(descriptor);
			this.addResourcesDescriptor(request);
		}
	}

	@Override
	public String updateStatement(String statementId, String statement) throws CloudManagementException {
		return this.cepDeployer.updateStatement(statementId, statement);
	}

	@Override
	public String getStatementById(String statementId) throws CloudManagementException {
		return this.cepDeployer.getStatementById(statementId);
	}

	@Override
	public String deleteStatement(String statementId) throws CloudManagementException {
		return this.cepDeployer.deleteStatement(statementId);
	}

	@Override
	public String addStatement(String statementId, String statement) throws CloudManagementException {
		return this.cepDeployer.addStatement(statementId, statement);
	}

	@Override
	public ListAllStatementsResponse listAllStatements(ListAllStatements parameters)
			throws CloudManagementException {
		return this.cepDeployer.listAllStatements(parameters);
	}

	@Override
	public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters)
			throws CloudManagementException {
		return this.cepDeployer.addStatementWithActions(parameters);
	}

	public void stop() {
		if (!useEventCloudMock) {
			if (this.eventcloudPubSub != null) {
				((EventCloudPubSubModule) this.eventcloudPubSub).cleanup();
				EventCloudsManagementServiceDeployer.destroy();
			}
		}
	}


	private static File createTemporaryFile(InputStream is) {
		BufferedReader br = null;
		BufferedWriter bw = null;

		try {
			final File tmpFile = FileUtils.createTempFile(UUID.randomUUID().toString(), ".txt");
			br = new BufferedReader(new InputStreamReader(is));

			bw = new BufferedWriter(new FileWriter(tmpFile));
			String line = null;

			while ((line = br.readLine()) != null) {
				bw.write(line);
				bw.write('\n');
			}

			bw.flush();

			return tmpFile;
		} catch (IOException e) {
			throw new IllegalStateException(e);
		} finally {
			try {
				if (bw != null) {
					bw.close();
				}

				if (br != null) {
					br.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public DataManagerClientImplSOAP getDataGovClient() {
		if(dataGovClient == null) {
			this.dataGovClient = new DataManagerClientImplSOAP(this.easierGovAdresses.get(0).toString().replace("eventManager", "dataManager"));
		}
		return dataGovClient;
	}

	public EventManagerClientImplSOAP getEventGovClient() {
		if(eventGovClient == null) {
			this.eventGovClient = new EventManagerClientImplSOAP(this.easierGovAdresses.get(0).toString());
		}
		return eventGovClient;
	}

	@Override
	public void addResourcesDescriptorFromURL(String descriptorURL,
			boolean eraseOlders) throws CloudManagementException {
		try {
			AddResourcesDescriptor desc = new AddResourcesDescriptor();
			Document doc = null;
			System.out.println("add descriptor from url: " + descriptorURL);
			if(descriptorURL.startsWith(".")) {
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new File(descriptorURL).getCanonicalFile());
			} else {
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(URI.create(descriptorURL).toURL().openStream());
			}
			desc.setResourcesDescriptor(SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class));
			desc.setEraseOlders(eraseOlders);

			this.addResourcesDescriptor(desc);
		} catch(Exception e) {
			e.printStackTrace();
			throw new CloudManagementException(e.getMessage(), e);
		}
	}

	@Override
	public String ping() {
		return "I am alive!!!";
	}



}
