/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server;

import com.ebmwebsourcing.easierbsm.admin.client.impl.BSMAdminClientImplSOAP;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.eval.EvalLogger;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEsperDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.ESBDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.MonitoringDeployerModule;
import com.ebmwebsourcing.seacloud.model.CEPModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.ESBPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModuleMocked;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.petalslink.data_api._1.PublishSchemaFromDOM;
import com.petalslink.data_api._1.PublishSchemaFromDOMResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.data._1.Statistics;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@WebService(serviceName="CloudManagementService", portName="CloudManagementSOAPEndpoint", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class SeaCloudManagementImpl
implements CloudManagement {
    private static final Logger LOG = Logger.getLogger(SeaCloudManagementImpl.class.getName());
    private static final String EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME = "eventcloud.activate.loggers";
    private ESBDeployerModule esbDeployer = null;
    private MonitoringDeployerModule bsmDeployer = null;
    private CEPModule cepDeployer = null;
    private PubSubModule esbPubSub = null;
    private PubSubModule eventcloudPubSub = null;
    private SeaCloud.CEP_MODE mode = null;
    private String seaCloudAddress;
    private boolean useCepMock = false;
    private boolean useEventCloudMock = false;
    private List<ResourcesDescriptor> descriptors = new ArrayList<ResourcesDescriptor>();
    private List<URL> eventClouds = new ArrayList<URL>();
    private List<URL> cepEngines = new ArrayList<URL>();
    private List<URL> esbNodes = new ArrayList<URL>();
    private List<URL> monitoring = new ArrayList<URL>();
    private List<URL> easierGovAdresses = new ArrayList<URL>();
    private DataManagerClientImplSOAP dataGovClient = null;
    private EventManagerClientImplSOAP eventGovClient = null;
    private Statistics stats = new Statistics();

    public SeaCloudManagementImpl(ResourcesDescriptor descriptor, String seaCloudAddress, SeaCloud.CEP_MODE mode, boolean useCepMock, boolean useEventCloudMock) throws CloudManagementException {
        this.seaCloudAddress = seaCloudAddress;
        this.useCepMock = useCepMock;
        this.useEventCloudMock = useEventCloudMock;
        this.mode = mode;
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        EJaxbSubscribeResponse _esbreturn = null;
        LOG.info("Executing operation subscribe on SeaCloud");
        this.stats.setNumbersOfSubscription(this.stats.getNumbersOfSubscription() + 1);
        System.out.println(subscribeRequest);
        try {
            LOG.info("Executing subscription on eventcloudPubSub module");
            EJaxbSubscribeResponse _eventCloudreturn = this.eventcloudPubSub.subscribe(subscribeRequest);
            subscribeRequest.getConsumerReference().getAddress().setValue(this.seaCloudAddress);
            LOG.info("Executing subscription on esbPubSub module");
            _esbreturn = this.esbPubSub.subscribe(subscribeRequest);
            LOG.info("End of subscription on SeaCloud");
        }
        catch (RuntimeException e) {
            LOG.severe("Error to subscribe in SeaCloud");
            e.printStackTrace();
            throw e;
        }
        return _esbreturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EJaxbNotify notify) {
        EvalLogger.getInstance().logNotif(this.getClass(), "SeaCloud", EvalLogger.Direction.Entry, notify);
        LOG.info("Executing operation notify");
        this.stats.setNumbersOfNotification(this.stats.getNumbersOfNotification() + 1);
        System.out.println(notify);
        try {
            System.out.println("eventCloud class: " + this.eventcloudPubSub.getClass());
            this.eventcloudPubSub.notify(notify);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            EvalLogger.getInstance().logNotif(this.getClass(), "SeaCloud", EvalLogger.Direction.Exit, notify);
        }
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws CloudManagementException {
        EJaxbDeployResponse _return;
        block9: {
            LOG.info("Executing operation deploy");
            System.out.println(parameters);
            _return = null;
            LOG.info("Resource to deploy: " + parameters.getMainResource().getFileURI().toString());
            try {
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".bpel")) {
                    this.stats.setNumbersOfBpelsDeployed(this.stats.getNumbersOfBpelsDeployed() + 1);
                    _return = this.esbDeployer.deploy(parameters);
                    break block9;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".cep")) {
                    System.out.println("deploy cep rule");
                    this.stats.setNumbersOfCEPRulesDeployed(this.stats.getNumbersOfCEPRulesDeployed() + 1);
                    Document doc = null;
                    doc = SeaCloudManagementImpl.extractDocumentFrom(parameters);
                    AddStatementWithActions cepRule = (AddStatementWithActions)SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementWithActions.class);
                    this.cepDeployer.addStatementWithActions(cepRule);
                    _return = new EJaxbDeployResponse();
                    break block9;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".soc")) {
                    this.stats.setNumbersOfSocialGraphDeployed(this.stats.getNumbersOfSocialGraphDeployed() + 1);
                    if (this.useEventCloudMock) {
                        System.out.println("************* Use EventCloudPubSubModuleMocked");
                        _return = ((EventCloudPubSubModuleMocked)this.eventcloudPubSub).deploy(parameters);
                        break block9;
                    }
                    throw new CloudManagementException("TODO: Not implemented => [LIRIS] call the social filter to set relation graph!!!");
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".ela")) {
                    this.stats.setNumbersOfELADeployed(this.stats.getNumbersOfELADeployed() + 1);
                    _return = this.bsmDeployer.deploy(parameters);
                    break block9;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".xsd")) {
                    System.out.println("deploy xsd schema");
                    this.stats.setNumbersOfXSDDeployed(this.stats.getNumbersOfXSDDeployed() + 1);
                    Document doc = null;
                    doc = SeaCloudManagementImpl.extractDocumentFrom(parameters);
                    PublishSchemaFromDOM request = new PublishSchemaFromDOM();
                    request.setAny((Object)doc.getDocumentElement());
                    PublishSchemaFromDOMResponse resp = this.getDataGovClient().publishSchemaFromDOM(request);
                    _return = new EJaxbDeployResponse();
                    break block9;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".topns")) {
                    System.out.println("deploy topicnamespace");
                    this.stats.setNumbersOfTopicNamespaceDeployed(this.stats.getNumbersOfTopicNamespaceDeployed() + 1);
                    Document doc = null;
                    doc = SeaCloudManagementImpl.extractDocumentFrom(parameters);
                    PublishTopicNamespaceFromDOM request = new PublishTopicNamespaceFromDOM();
                    request.setTopicNamespace((EJaxbTopicNamespaceType)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbTopicNamespaceType.class));
                    PublishTopicNamespaceFromDOMResponse resp = this.getEventGovClient().publishTopicNamespaceFromDOM(request);
                    _return = new EJaxbDeployResponse();
                    break block9;
                }
                throw new CloudManagementException("Kind of file not supported here: " + parameters.getMainResource().getFileURI().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CloudManagementException(e.getMessage(), (Throwable)e);
            }
        }
        return _return;
    }

    public static Document extractDocumentFrom(EJaxbDeploy parameters) throws IOException, SAXException, ParserConfigurationException, FileNotFoundException, MalformedURLException {
        Document doc;
        if (parameters.getMainResource().getAttachment().getInputStream() != null) {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(parameters.getMainResource().getAttachment().getInputStream());
        } else if (parameters.getMainResource().getFileURI().toString().startsWith(".")) {
            System.out.println("local file detected: " + new File(parameters.getMainResource().getFileURI()).getCanonicalFile());
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new FileInputStream(new File(parameters.getMainResource().getFileURI()).getCanonicalFile()));
        } else {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new URL(parameters.getMainResource().getFileURI()).openStream());
        }
        return doc;
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        LOG.info("Executing operation getResourceProperty");
        System.out.println(getResourcePropertyRequest);
        EJaxbGetResourcePropertyResponse _return = new EJaxbGetResourcePropertyResponse();
        if (getResourcePropertyRequest.getLocalPart().equals("resourcesDescriptors")) {
            for (ResourcesDescriptor rsc : this.descriptors) {
                _return.getAny().add(rsc);
            }
        } else if (getResourcePropertyRequest.getLocalPart().equals("statistics")) {
            _return.getAny().add(this.stats);
        }
        return _return;
    }

    public BindResponse bind(Bind parameters) throws CloudManagementException {
        LOG.info("Executing operation bind");
        System.out.println(parameters);
        BindResponse _return = this.esbDeployer.bind(parameters);
        return _return;
    }

    public String expose(QName serviceName, String endpointName) throws CloudManagementException {
        LOG.info("Executing operation expose");
        System.out.println(serviceName);
        System.out.println(endpointName);
        String _return = this.esbDeployer.expose(serviceName, endpointName);
        return _return;
    }

    public ProxifyResponse proxify(Proxify parameters) throws CloudManagementException {
        LOG.info("Executing operation proxify");
        System.out.println(parameters);
        ProxifyResponse _return = this.esbDeployer.proxify(parameters);
        return _return;
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        LOG.info("Executing operation unsubscribe");
        System.out.println(unsubscribeRequest);
        EJaxbUnsubscribeResponse _eventCloudreturn = this.eventcloudPubSub.unsubscribe(unsubscribeRequest);
        EJaxbUnsubscribeResponse _esbreturn = this.esbPubSub.unsubscribe(unsubscribeRequest);
        return _esbreturn;
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters) throws CloudManagementException {
        AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
        try {
            if (parameters.isEraseOlders()) {
                this.eventClouds = new ArrayList<URL>();
                this.cepEngines = new ArrayList<URL>();
                this.esbNodes = new ArrayList<URL>();
                this.monitoring = new ArrayList<URL>();
                this.easierGovAdresses = new ArrayList<URL>();
                this.descriptors = new ArrayList<ResourcesDescriptor>();
            }
            for (Resource rsc : parameters.getResourcesDescriptor().getResource()) {
                if (ResourceType.CEP_ENGINE.equals((Object)rsc.getType())) {
                    this.cepEngines.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.ESB.equals((Object)rsc.getType())) {
                    this.esbNodes.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.EVENT_CLOUD.equals((Object)rsc.getType())) {
                    this.eventClouds.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.MONITORING.equals((Object)rsc.getType())) {
                    this.monitoring.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (!ResourceType.GOVERNANCE.equals((Object)rsc.getType())) continue;
                this.easierGovAdresses.add(new URL(rsc.getAddress()));
            }
            this.esbDeployer = new ESBDeployerModule(this.esbNodes);
            this.bsmDeployer = new MonitoringDeployerModule(this.monitoring);
            URL easierGovAdress = null;
            if (this.easierGovAdresses.size() > 0) {
                easierGovAdress = this.easierGovAdresses.get(0);
                ConnexionManagerClientImplSOAP clientConnectGov = new ConnexionManagerClientImplSOAP(easierGovAdress.toString().replace("eventManager", "connexionManager"));
                for (URL node : this.esbNodes) {
                    ConnectToEnvironment request = new ConnectToEnvironment();
                    request.setEndpointAddress(node.toString());
                    clientConnectGov.connectToEnvironment(request);
                    AdminClientImplSOAP esbClient = new AdminClientImplSOAP(node.toString());
                    esbClient.connectToGovernance(easierGovAdress.toString());
                }
            }
            if (this.mode == SeaCloud.CEP_MODE.ESPER) {
                this.cepDeployer = new CEPEsperDeployerModule(this.cepEngines, this.seaCloudAddress, easierGovAdress);
            }
            this.cepDeployer.addResourcesDescriptor(parameters);
            this.esbPubSub = new ESBPubSubModule(this.esbNodes);
            if (this.useEventCloudMock) {
                System.out.println("************* Use EventCloudPubSubModuleMocked");
                this.eventcloudPubSub = new EventCloudPubSubModuleMocked(this.eventClouds);
            } else {
                System.out.println("************* Use EventCloudPubSubModule");
                this.eventcloudPubSub = new EventCloudPubSubModule(this.eventClouds);
            }
            for (URL bsm : this.monitoring) {
                BSMAdminClientImplSOAP bsmclient = new BSMAdminClientImplSOAP(bsm.toString());
                for (URL eventcloud : this.eventClouds) {
                    bsmclient.connectToEsb(eventcloud.toString(), Boolean.valueOf(false));
                }
            }
            this.descriptors.add(0, parameters.getResourcesDescriptor());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public List<ResourcesDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public String updateStatement(String statementId, String statement) throws CloudManagementException {
        return this.cepDeployer.updateStatement(statementId, statement);
    }

    public String getStatementById(String statementId) throws CloudManagementException {
        return this.cepDeployer.getStatementById(statementId);
    }

    public String deleteStatement(String statementId) throws CloudManagementException {
        return this.cepDeployer.deleteStatement(statementId);
    }

    public String addStatement(String statementId, String statement) throws CloudManagementException {
        return this.cepDeployer.addStatement(statementId, statement);
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements parameters) throws CloudManagementException {
        return this.cepDeployer.listAllStatements(parameters);
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        return this.cepDeployer.addStatementWithActions(parameters);
    }

    public void stop() {
        if (!this.useEventCloudMock && this.eventcloudPubSub != null) {
            ((EventCloudPubSubModule)this.eventcloudPubSub).cleanup();
        }
    }

    public DataManagerClientImplSOAP getDataGovClient() {
        if (this.dataGovClient == null) {
            this.dataGovClient = new DataManagerClientImplSOAP(this.easierGovAdresses.get(0).toString().replace("eventManager", "dataManager"));
        }
        return this.dataGovClient;
    }

    public EventManagerClientImplSOAP getEventGovClient() {
        if (this.eventGovClient == null) {
            this.eventGovClient = new EventManagerClientImplSOAP(this.easierGovAdresses.get(0).toString());
        }
        return this.eventGovClient;
    }

    public void addResourcesDescriptorFromURL(String descriptorURL, boolean eraseOlders) throws CloudManagementException {
        try {
            AddResourcesDescriptor desc = new AddResourcesDescriptor();
            Document doc = null;
            System.out.println("add descriptor from url: " + descriptorURL);
            doc = descriptorURL.startsWith(".") ? DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new File(descriptorURL).getCanonicalFile()) : DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(URI.create(descriptorURL).toURL().openStream());
            desc.setResourcesDescriptor((ResourcesDescriptor)SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class));
            desc.setEraseOlders(eraseOlders);
            this.addResourcesDescriptor(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public String ping() {
        return "I am alive!!!";
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{engine.cep.admin.api.ObjectFactory.class, easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory.class, easybox.org.w3._2005._08.addressing.ObjectFactory.class, seacloud.petalslink.com.data._1.ObjectFactory.class, ObjectFactory.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

