/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server.ui;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.seacloud.server.DeployerResult;
import com.ebmwebsourcing.seacloud.server.ui.model.CepNode;
import com.ebmwebsourcing.seacloud.server.ui.model.EventCloudNode;
import com.ebmwebsourcing.seacloud.server.ui.model.SeaCloudNode;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.impl.RegistryImpl;
import org.petalslink.easiestdemo.client.model.impl.gov.GovNodeImpl;

public class SeaCloudRegistry
extends RegistryImpl
implements Registry {
    SeaCloudNode seaCloudNode;
    List<CepNode> cepNodes = new ArrayList<CepNode>();
    List<EventCloudNode> eventCloudNodes = new ArrayList<EventCloudNode>();

    public SeaCloudNode getSeaCloudNode() {
        return this.seaCloudNode;
    }

    public void setDeployerResult(DeployerResult result) throws SOAPException {
        try {
            this.cepNodes.clear();
            this.eventCloudNodes.clear();
            this.seaCloudNode = new SeaCloudNode(result.getSeaCloud().getAddress(), this);
            for (String cepAddress : result.getCepNodes().keySet()) {
                this.cepNodes.add(new CepNode(cepAddress, this));
            }
            for (String eventAddress : result.getEventCloudNodes().keySet()) {
                this.eventCloudNodes.add(new EventCloudNode(eventAddress, this));
            }
            if (result.getEasierGovAdmin() != null) {
                this.govNode = new GovNodeImpl(result.getEasierGovAdmin(), (Registry)this);
            }
            for (String adminWsdlUrl : result.getEsbNodes().keySet()) {
                org.petalslink.easiestdemo.client.model.api.esb.Node node = this.addNewAdminWsdlofESBNode(new URL[]{new URL(adminWsdlUrl + "?wsdl")});
                if (result.getEsbNodes().get(adminWsdlUrl) != null) {
                    Node n = (Node)result.getEsbNodes().get(adminWsdlUrl);
                    node.setModel(n);
                    node.setBasicInfos((EJaxbBasicNodeInformationsType)((NodeType)n.getModel()).getBasicNodeInformations().getModelObject());
                }
                this.nodes.add(node);
                this.govNode.getConnectedNodes().add(node);
            }
        }
        catch (MalformedURLException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public List<CepNode> getCepNodes() {
        return this.cepNodes;
    }

    public List<EventCloudNode> getEventCloudNodes() {
        return this.eventCloudNodes;
    }
}

