/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server.ui;

import com.ebmwebsourcing.seacloud.server.ui.CepG;
import com.ebmwebsourcing.seacloud.server.ui.EventCloudG;
import com.ebmwebsourcing.seacloud.server.ui.LineSeaCloudToCepG;
import com.ebmwebsourcing.seacloud.server.ui.LineSeaCloudToEsbG;
import com.ebmwebsourcing.seacloud.server.ui.LineSeaCloudToEventCloudG;
import com.ebmwebsourcing.seacloud.server.ui.LineSeaCloudToGovG;
import com.ebmwebsourcing.seacloud.server.ui.SeaCloudG;
import com.ebmwebsourcing.seacloud.server.ui.SeaCloudRegistry;
import com.ebmwebsourcing.seacloud.server.ui.SeaCloudUI;
import com.ebmwebsourcing.seacloud.server.ui.model.CepNode;
import com.ebmwebsourcing.seacloud.server.ui.model.EventCloudNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.gui.PropertiesTableModel;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.GovG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.LineEsbOrGovToEndpointG;
import org.petalslink.easiestdemo.client.topology.ProvidedServiceG;
import org.petalslink.easiestdemo.client.topology.TopologyView;

public class SeaCloudTopologyView
extends TopologyView {
    private SeaCloudG seaCloudG;
    private List<CepG> cepG = new ArrayList<CepG>();
    private List<EventCloudG> eventCloudG = new ArrayList<EventCloudG>();
    private static final long serialVersionUID = 1L;

    public SeaCloudTopologyView(Dimension dim, SeaCloudUI client) {
        super(dim, (WSOUIClient)client);
    }

    public void refresh() {
        super.refresh();
        if (((SeaCloudRegistry)this.registry).getSeaCloudNode() != null) {
            int spacey_client;
            this.seaCloudG = new SeaCloudG(this, ((SeaCloudRegistry)this.registry).getSeaCloudNode(), 20, 200);
            int init_client_x = this.getSize().width - (SeaCloudG.DEFAULT_WIDTH + SeaCloudG.DEFAULT_WIDTH / 2);
            int init_client_y = spacey_client = this.getSize().height / (((SeaCloudRegistry)this.registry).getSeaCloudNode().getProvidedServices().size() + 1);
            for (ProvidedService providedService : ((SeaCloudRegistry)this.registry).getSeaCloudNode().getProvidedServices()) {
                if (this.findExternalClientEndpointGCorrespondingToThisEndpoint((ClientEndpointProxy)providedService) != null) continue;
                this.externalClientEndpoints.add(new ExternalClientEndpointG((TopologyView)this, (ClientEndpointProxy)providedService, init_client_x, init_client_y));
                init_client_y += spacey_client;
            }
        }
        int posX = (int)this.getSize().getWidth() / 2 - CepG.DEFAULT_WIDTH / 2;
        if (this.cepG == null) {
            this.cepG = new ArrayList<CepG>();
        } else {
            this.cepG.clear();
        }
        if (((SeaCloudRegistry)this.registry).getCepNodes() != null) {
            for (CepNode cep : ((SeaCloudRegistry)this.registry).getCepNodes()) {
                this.cepG.add(new CepG(this, cep, posX, 50));
            }
        }
        posX = (int)this.getSize().getWidth() / 2 - EventCloudG.DEFAULT_WIDTH / 2;
        if (this.eventCloudG == null) {
            this.eventCloudG = new ArrayList<EventCloudG>();
        } else {
            this.eventCloudG.clear();
        }
        if (((SeaCloudRegistry)this.registry).getEventCloudNodes() != null) {
            for (EventCloudNode ev : ((SeaCloudRegistry)this.registry).getEventCloudNodes()) {
                this.eventCloudG.add(new EventCloudG(this, ev, posX, 120));
            }
        }
        for (EsbG esb : this.esbs) {
            ArrayList<InternalProviderProxyEndpointG> ipps = new ArrayList<InternalProviderProxyEndpointG>();
            for (InternalProviderProxyEndpointG ipp : esb.getProxyProviders()) {
                if (!ipp.getQName().getLocalPart().toLowerCase().contains("seacloud")) continue;
                ipps.add(ipp);
            }
            for (InternalProviderProxyEndpointG ipp : ipps) {
                esb.getProxyProviders().remove(ipp);
            }
        }
        ArrayList<ExternalProviderEndpointG> epps = new ArrayList<ExternalProviderEndpointG>();
        for (ExternalProviderEndpointG epp : this.externalProviderEndpoints) {
            if (!epp.getQName().getLocalPart().toLowerCase().contains("seacloud")) continue;
            epps.add(epp);
        }
        for (ExternalProviderEndpointG epp : epps) {
            this.externalProviderEndpoints.remove(epp);
        }
        this.repaint();
    }

    public Object getObjectContainedIn(MouseEvent evt) {
        Object res = super.getObjectContainedIn(evt);
        if (res == null && this.seaCloudG != null) {
            for (ProvidedServiceG providedService : this.seaCloudG.getProvidedServices()) {
                if (res != null || !providedService.contains(evt.getX(), evt.getY())) continue;
                res = providedService;
                break;
            }
        }
        return res;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.white);
        g2.drawRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.seaCloudG != null) {
            new LineSeaCloudToGovG(this.seaCloudG, this.govg).update(g);
            if (this.client.getCustomView().showClientEndpoint()) {
                for (ProvidedServiceG icpe : this.seaCloudG.getProvidedServices()) {
                    for (ExternalClientEndpointG ece : this.externalClientEndpoints) {
                        if (!icpe.getQName().equals(ece.getQName())) continue;
                        new LineEsbOrGovToEndpointG(icpe, ece).update(g);
                    }
                }
            }
            for (EsbG nodeG : this.esbs) {
                if (nodeG.getModel().isMonitoringNode()) continue;
                new LineSeaCloudToEsbG(this.seaCloudG, nodeG).update(g);
            }
            if (this.cepG != null) {
                for (CepG cep : this.cepG) {
                    new LineSeaCloudToCepG(this.seaCloudG, cep).update(g);
                }
            }
            if (this.eventCloudG != null) {
                for (EventCloudG eventCloud : this.eventCloudG) {
                    new LineSeaCloudToEventCloudG(this.seaCloudG, eventCloud).update(g);
                }
            }
        }
        this.draw(g);
        if (this.seaCloudG != null) {
            this.seaCloudG.update(g);
        }
        if (this.cepG != null) {
            for (CepG cep : this.cepG) {
                cep.update(g);
            }
        }
        if (this.eventCloudG != null) {
            for (EventCloudG eventCloud : this.eventCloudG) {
                eventCloud.update(g);
            }
        }
        if (this.internalEndpointToPrint != null) {
            g.setColor(this.internalEndpointToPrint.getColor());
            g.drawString(this.internalEndpointToPrint.getText(), (int)this.internalEndpointToPrint.getX(), (int)this.internalEndpointToPrint.getY());
        }
        g.dispose();
    }

    protected void formMouseDragged(MouseEvent evt) {
        super.formMouseDragged(evt);
        if (this.draggedItem != null) {
            if (this.draggedItem instanceof SeaCloudG) {
                ((SeaCloudG)((Object)this.draggedItem)).setLocation(evt.getX(), evt.getY());
            } else if (this.draggedItem instanceof CepG) {
                ((CepG)((Object)this.draggedItem)).setLocation(evt.getX(), evt.getY());
            } else if (this.draggedItem instanceof EventCloudG) {
                ((EventCloudG)((Object)this.draggedItem)).setLocation(evt.getX(), evt.getY());
            }
            this.repaint();
        }
    }

    protected void formMousePressed(MouseEvent evt) {
        super.formMousePressed(evt);
        if (this.draggedItem == null && this.seaCloudG != null && this.seaCloudG.contains(evt.getX(), evt.getY())) {
            this.draggedItem = this.seaCloudG;
            this.seaCloudG.setMove(true);
        }
        if (this.draggedItem == null) {
            for (CepG cepG : this.cepG) {
                if (!cepG.contains(evt.getX(), evt.getY())) continue;
                this.draggedItem = cepG;
                cepG.setMove(true);
                break;
            }
        }
        if (this.draggedItem == null) {
            for (EventCloudG eventCloudG : this.eventCloudG) {
                if (!eventCloudG.contains(evt.getX(), evt.getY())) continue;
                this.draggedItem = eventCloudG;
                eventCloudG.setMove(true);
                break;
            }
        }
    }

    protected void formMouseReleased(MouseEvent evt) {
        super.formMouseReleased(evt);
        if (this.draggedItem instanceof GovG) {
            ((SeaCloudG)((Object)this.draggedItem)).setMove(false);
        }
        if (this.draggedItem instanceof CepG) {
            ((CepG)((Object)this.draggedItem)).setMove(false);
        }
        if (this.draggedItem instanceof EventCloudG) {
            ((EventCloudG)((Object)this.draggedItem)).setMove(false);
        }
        this.draggedItem = null;
    }

    protected void formMouseMoved(MouseEvent evt) {
        super.formMouseMoved(evt);
        Object selectedItem = this.getObjectContainedIn(evt);
        if (selectedItem instanceof SeaCloudG) {
            this.client.getjTableProperties().setModel((TableModel)new PropertiesTableModel(((SeaCloudG)((Object)selectedItem)).getProperties()));
        } else if (selectedItem instanceof CepG) {
            this.client.getjTableProperties().setModel((TableModel)new PropertiesTableModel(((CepG)((Object)selectedItem)).getProperties()));
        } else if (selectedItem instanceof EventCloudG) {
            this.client.getjTableProperties().setModel((TableModel)new PropertiesTableModel(((EventCloudG)((Object)selectedItem)).getProperties()));
        }
        this.repaint();
    }

    protected void formMouseEntered(MouseEvent evt) {
    }
}

