/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server.ui;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.seacloud.server.DeployerResult;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.ui.SeaCloudRegistry;
import com.ebmwebsourcing.seacloud.server.ui.SeaCloudTopologyView;
import com.petalslink.easiergov.GovException;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.URIResolver;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.util.SpecificClasspathURIResolver;
import org.w3c.dom.Document;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class SeaCloudUI
extends WSOUIClient {
    private static final long serialVersionUID = 1L;
    private SeaCloud server = null;
    private DeployerResult result = null;
    private boolean useCepMock = false;
    private boolean useEventCloudMock = false;
    private boolean create = false;
    private SeaCloud.CEP_MODE mode;
    private String seaCloudAdminAddress;

    public SeaCloudUI() throws WSOUIClientException {
        this(null, null, null, false, true, true);
    }

    public SeaCloudUI(String seaCloudAdminAddress, SeaCloud.CEP_MODE mode, ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock) throws WSOUIClientException {
        try {
            this.getJPanelView().removeAll();
            this.registry = new SeaCloudRegistry();
            this.topology = new SeaCloudTopologyView(this.getJPanelView().getSize(), this);
            this.useCepMock = useCepMock;
            this.useEventCloudMock = useEventCloudMock;
            this.create = create;
            this.seaCloudAdminAddress = seaCloudAdminAddress;
            this.mode = mode;
            this.getJPanelView().add((Component)this.topology);
            this.server = new SeaCloud(seaCloudAdminAddress, descriptor, mode, useCepMock, useEventCloudMock);
            this.server.start();
            this.refreshAll();
        }
        catch (Exception e) {
            throw new WSOUIClientException((Throwable)e);
        }
    }

    public void refreshAll() throws WSOUIClientException {
        if (this.server != null && this.server.getDescriptors() != null && this.server.getDescriptors().size() > 0) {
            try {
                this.result = SeaCloudUI.createDeployerResultFromDescriptor((ResourcesDescriptor)this.server.getDescriptors().get(0), this.create, this.useCepMock, this.useEventCloudMock, true);
                this.result.setSeaCloud(this.server);
                ((SeaCloudRegistry)this.registry).setDeployerResult(this.result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.refreshAll();
    }

    public SeaCloud getServer() {
        return this.server;
    }

    public void setServer(SeaCloud server) {
        this.server = server;
    }

    public static ResourcesDescriptor readDescriptor(URL resource) throws Exception {
        ResourcesDescriptor rsc = null;
        InputStream is = resource.openStream();
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
        rsc = (ResourcesDescriptor)SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class);
        is.close();
        return rsc;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String seaCloudServerAddress = "http://localhost:8234/SeaCloudAdmin";
                    ResourcesDescriptor descriptor = null;
                    SeaCloudUI c = new SeaCloudUI(seaCloudServerAddress, SeaCloud.CEP_MODE.ESPER, descriptor, false, false, false);
                    c.setVisible(true);
                    c.refreshAll();
                }
                catch (WSOUIClientException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static DeployerResult createDeployerResultFromDescriptor(ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock, boolean activeUI) throws MalformedURLException, ESBException, TransportException, GovException, CloudManagementException, IOException, ConnectToEnvironmentFault, ManagementException {
        DeployerResult result = new DeployerResult();
        boolean esbCpt = false;
        boolean monitCpt = false;
        Object easiergovConnexionManager = null;
        Object easiergovEventManager = null;
        if (descriptor != null) {
            System.out.println("---------------------------------- deb");
            for (Resource rsc : descriptor.getResource()) {
                if (ResourceType.ESB.equals((Object)rsc.getType())) {
                    URL esbAddress = new URL(rsc.getAddress());
                    result.getEsbNodes().put(esbAddress.toString(), null);
                    continue;
                }
                if (ResourceType.GOVERNANCE.equals((Object)rsc.getType())) {
                    int port = new URL(rsc.getAddress()).getPort();
                    String host = new URL(rsc.getAddress()).getHost();
                    result.setEasierGovAdmin("http://" + host + ":" + port + "/services/adminManager");
                    continue;
                }
                if (ResourceType.CEP_ENGINE.equals((Object)rsc.getType())) {
                    result.getCepNodes().put(rsc.getAddress(), null);
                    continue;
                }
                if (ResourceType.EVENT_CLOUD.equals((Object)rsc.getType())) {
                    result.getEventCloudNodes().put(rsc.toString(), null);
                    continue;
                }
                if (ResourceType.MONITORING.equals((Object)rsc.getType())) {
                    result.getBsmNodes().put(rsc.toString(), null);
                    continue;
                }
                throw new CloudManagementException("Resource deployment not implemented for: " + rsc.getType());
            }
            System.out.println("---------------------------------- fin");
        }
        return result;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{seacloud.petalslink.com.data._1.ObjectFactory.class, ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        SOAUtil.getInstance().getXmlContext((Framework)EasiestDEMOFramework.getInstance()).setURIResolver((URIResolver)new URIMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), new SpecificClasspathURIResolver()}));
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasiestDEMOFramework.getInstance()));
    }
}

