/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.CEPDeployer;

import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.CEPModule;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import engine.cep.admin.api.Action;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.Namespace;
import engine.cep.admin.api.SubscriptionsRequired;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class CEPEsperDeployerModule
extends AbstractModule
implements CEPModule {
    private String seaCloudAddress;
    private URL easierGov;
    private EventManagerClientImplSOAP easierGovClient;

    public CEPEsperDeployerModule(List<URL> adminAdresses, String seaCloudAddress, URL easierGov) throws CloudManagementException {
        super(adminAdresses);
        this.seaCloudAddress = seaCloudAddress;
        this.easierGov = easierGov;
        if (easierGov != null) {
            this.easierGovClient = new EventManagerClientImplSOAP(this.easierGov.toString());
        }
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements parameters) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.listAllStatements(parameters);
    }

    public String addStatement(String statementId, String statement) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.addStatement(statementId, statement);
    }

    public String deleteStatement(String statementId) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.deleteStatement(statementId);
    }

    public String getStatementById(String statementId) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.getStatementById(statementId);
    }

    public String updateStatement(String statementId, String statement) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.updateStatement(statementId, statement);
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        AddStatementResponseWithActions res = null;
        try {
            System.out.println("1 ************************** findPrimitiveEventsInRule");
            List<QName> primitivesEvent = this.findPrimitiveEventsInRule(parameters.getStatement(), parameters.getNamespaceOfEventTypes());
            System.out.println("2 ************************** findCorrespondingTopicsFromPrimitivesEvents");
            Map<QName, QName> topics = this.findCorrespondingTopicsFromPrimitivesEvents(primitivesEvent);
            System.out.println("3 ************************** createSubscriptionsRequired");
            SubscriptionsRequired subscriptionsRequired = this.createSubscriptionsRequired(topics);
            parameters.setSubscriptionsRequired(subscriptionsRequired);
            System.out.println("4 ************************** completeActionsByAddingPublishLocation");
            this.completeActionsByAddingPublishLocation(parameters.getAction());
            System.out.println("5 ************************** SeaCloudClientSOAP");
            URL urlCEP = (URL)this.externalComponentAdresses.get(0);
            SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
            res = client.addStatementWithActions(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private void completeActionsByAddingPublishLocation(List<Action> actions) throws CloudManagementException {
        for (Action a : actions) {
            if (!a.getType().equals("event")) continue;
            QName topic = this.findCorrespondingTopicFromElement(a.getName());
            String eventIdCloud = this.getEventCloudIdURLFromTopic(topic);
            a.getPublishDestination().add(eventIdCloud);
        }
    }

    private String getEventCloudIdURLFromTopic(QName topic) {
        return this.seaCloudAddress;
    }

    private SubscriptionsRequired createSubscriptionsRequired(Map<QName, QName> topics) {
        SubscriptionsRequired subscriptionsRequired = new SubscriptionsRequired();
        for (Map.Entry<QName, QName> topic : topics.entrySet()) {
            SubscriptionsRequired.Entry entry = new SubscriptionsRequired.Entry();
            entry.setCorrespondingEvent(topic.getKey());
            entry.setTopic(topic.getValue());
            entry.setEndpointAddressToSubscribe(this.seaCloudAddress);
            subscriptionsRequired.getEntry().add(entry);
        }
        return subscriptionsRequired;
    }

    public Map<QName, QName> findCorrespondingTopicsFromPrimitivesEvents(List<QName> primitivesEvent) throws CloudManagementException {
        HashMap<QName, QName> topics = new HashMap<QName, QName>();
        for (QName event : primitivesEvent) {
            QName topic = this.findCorrespondingTopicFromElement(event);
            if (topic == null) continue;
            topics.put(event, topic);
        }
        return topics;
    }

    public List<QName> findPrimitiveEventsInRule(String rule, List<Namespace> namespaceOfEventTypes) throws CloudManagementException {
        ArrayList<QName> primitiveEvents;
        block16: {
            String[] events;
            block17: {
                String[] events2;
                block15: {
                    String[] events3;
                    primitiveEvents = new ArrayList<QName>();
                    if (!rule.toLowerCase().contains("from") || !rule.toLowerCase().contains("where")) break block15;
                    String shortRule = rule.substring(rule.toLowerCase().indexOf("from") + "from".length(), rule.toLowerCase().indexOf("where"));
                    for (String longEvent : events3 = shortRule.trim().split(",")) {
                        String event = null;
                        if (longEvent.trim().indexOf(".") > 0) {
                            event = longEvent.trim().substring(0, longEvent.trim().indexOf("."));
                        } else if (longEvent.trim().indexOf(" ") > 0) {
                            event = longEvent.trim().substring(0, longEvent.trim().indexOf(""));
                        }
                        QName eventQName = this.findEventInNamespace(event, namespaceOfEventTypes);
                        if (eventQName == null) {
                            throw new CloudManagementException("Impossible to find namespace corresponding to event: " + event);
                        }
                        if (primitiveEvents.contains(eventQName)) continue;
                        primitiveEvents.add(eventQName);
                    }
                    break block16;
                }
                if (!rule.toLowerCase().contains("from") || !rule.toLowerCase().contains("group")) break block17;
                String shortRule = rule.substring(rule.toLowerCase().indexOf("from") + "from".length(), rule.toLowerCase().indexOf("group"));
                System.out.println("shortRule avant = " + shortRule);
                shortRule = shortRule.substring(0, shortRule.indexOf("(")) + shortRule.substring(shortRule.indexOf(")") + 1, shortRule.length());
                System.out.println("shortRule = " + shortRule);
                for (String longEvent : events2 = shortRule.trim().split(",")) {
                    String event = null;
                    if (longEvent.trim().indexOf(".") > 0) {
                        event = longEvent.trim().substring(0, longEvent.trim().indexOf("."));
                    } else if (longEvent.trim().indexOf(" ") > 0) {
                        event = longEvent.trim().substring(0, longEvent.trim().indexOf(""));
                    }
                    QName eventQName = this.findEventInNamespace(event, namespaceOfEventTypes);
                    if (eventQName == null) {
                        throw new CloudManagementException("Impossible to find namespace corresponding to event: " + event);
                    }
                    if (primitiveEvents.contains(eventQName)) continue;
                    primitiveEvents.add(eventQName);
                }
                break block16;
            }
            if (!rule.toLowerCase().contains("from")) break block16;
            String shortRule = rule.substring(rule.toLowerCase().indexOf("from") + "from".length(), rule.toLowerCase().length());
            System.out.println("shortRule avant = " + shortRule);
            shortRule = shortRule.substring(0, shortRule.indexOf("(")) + shortRule.substring(shortRule.indexOf(")") + 1, shortRule.length());
            System.out.println("shortRule = " + shortRule);
            for (String longEvent : events = shortRule.trim().split(",")) {
                String event = null;
                if (longEvent.trim().indexOf(".") > 0) {
                    event = longEvent.trim().substring(0, longEvent.trim().indexOf("."));
                } else if (longEvent.trim().indexOf(" ") > 0) {
                    event = longEvent.trim().substring(0, longEvent.trim().indexOf(""));
                }
                QName eventQName = this.findEventInNamespace(event, namespaceOfEventTypes);
                if (eventQName == null) {
                    throw new CloudManagementException("Impossible to find namespace corresponding to event: " + event);
                }
                if (primitiveEvents.contains(eventQName)) continue;
                primitiveEvents.add(eventQName);
            }
        }
        return primitiveEvents;
    }

    private QName findEventInNamespace(String event, List<Namespace> namespaceOfEventTypes) {
        for (Namespace ns : namespaceOfEventTypes) {
            if (!ns.getEventTypeName().equals(event)) continue;
            return new QName(ns.getNamespace(), ns.getEventTypeName(), ns.getPrefix());
        }
        return null;
    }

    private QName findCorrespondingTopicFromElement(QName name) throws CloudManagementException {
        QName topic = null;
        try {
            List topics = this.easierGovClient.findTopicsByElement(name);
            if (topics.size() >= 2) {
                throw new CloudManagementException("Too many topics found for element: " + name);
            }
            if (topics.size() > 0) {
                topic = (QName)topics.get(0);
            }
        }
        catch (FindTopicsByElementFault e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return topic;
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters) throws CloudManagementException {
        URL urlCEP = (URL)this.externalComponentAdresses.get(0);
        SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
        return client.addResourcesDescriptor(parameters);
    }
}

