package com.ebmwebsourcing.seacloud.pubsub;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.apache.cxf.frontend.ClientProxy;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;

import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsApi;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;


public class EventCloudPubSubModule extends AbstractModule implements PubSubModule,
        InitEventCloudPubSubModule {

    private static final Logger LOG = Logger.getLogger(EventCloudPubSubModule.class.getName());

    private String eventCloudsManagementWsEndpoint;
    private EventCloudsManagementWsApi eventCloudsManagementWsClient;
    private Set<String> topics;
    private Map<String, String> subscribeProxies;
    private Map<String, String> publishProxies;
    private boolean initialized;

    public EventCloudPubSubModule(List<URL> adminAddresses) throws CloudManagementException {
        super(adminAddresses);

        if (super.externalComponentAdresses.size() > 0) {
            this.eventCloudsManagementWsEndpoint = super.externalComponentAdresses.get(0).toString();
            this.initialized = false;

            this.init();
        } else {
            throw new CloudManagementException(
                "Cannot start EventCloudPubSubModule because no Event Clouds management web service endpoint has been given");
        }
    }

    public void init() {
        if (this.initialized) {
            this.cleanup();
        }

        this.eventCloudsManagementWsClient = WsClientFactory.createWsClient(EventCloudsManagementWsApi.class,
                this.eventCloudsManagementWsEndpoint);

        this.topics = new HashSet<String>();
        this.subscribeProxies = new HashMap<String, String>();
        this.publishProxies = new HashMap<String, String>();

        this.initialized = true;
    }

    public void destroyEventCloud(String topic) {
        this.eventCloudsManagementWsClient.destroyEventCloud(topic);
        this.topics.remove(topic);
        this.subscribeProxies.remove(topic);
        this.publishProxies.remove(topic);
    }

    public void destroyEventClouds() {
        for (String topic : this.topics) {
            this.destroyEventCloud(topic);
        }
    }

    public void cleanup() {
        if (this.initialized) {
            this.destroyEventClouds();

            ClientProxy.getClient(this.eventCloudsManagementWsClient).destroy();
            this.eventCloudsManagementWsClient = null;

            this.initialized = false;
        }
    }

    @Override
    public EJaxbDeployResponse setSocialFilterUri(EJaxbDeploy parameters) {
        String socialFilterUri = parameters.getMainResource().getFileURI();

        LOG.info("Setting the Social Filter URI to : " + socialFilterUri);
        this.eventCloudsManagementWsClient.setSocialFilter(socialFilterUri, 0.5);

        return new EJaxbDeployResponse();
    }

    @Override
    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
            throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault,
            UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault,
            InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault,
            UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault,
            InvalidProducerPropertiesExpressionFault {
        try {
            if (this.initialized) {
                String topic = getExpandedTopic(WSNHelper.getQNameInSimpleTopicExpression(WSNHelper
                        .getTopicExpressionInFilter(subscribeRequest.getFilter())));

                LOG.info("Received subscription on topic : " + topic);

                synchronized (this.topics) {
                    this.createEventCloudIfNotExist(topic);

                    if (!this.subscribeProxies.containsKey(topic)) {
                        this.subscribeProxies.put(topic,
                                this.eventCloudsManagementWsClient.deploySubscribeWsnService(topic));
                        LOG.info("New subscribe proxy for topic " + topic + " created");
                    }
                }

                UserManagementClientSOAP client = new UserManagementClientSOAP(
                    this.subscribeProxies.get(topic) + "?wsdl");

                return client.subscribe(subscribeRequest);
            } else {
                return new EJaxbSubscribeResponse();
            }
        } catch (WsnbException e) {
            throw new InvalidTopicExpressionFault(e.getMessage(), e);
        }
    }

    @Override
    public void notify(EJaxbNotify notify) {
        try {
            if (this.initialized) {
                System.out.println("%%%% notify: \n" +
                    XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(notify)));

                String topic = getExpandedTopic(WSNHelper.getQNameInSimpleTopicExpression(notify
                        .getNotificationMessage().get(0).getTopic()));

                LOG.info("Received notification on topic : " + topic);

                synchronized (this.topics) {
                    this.createEventCloudIfNotExist(topic);

                    if (!this.publishProxies.containsKey(topic)) {
                        this.publishProxies.put(topic,
                                this.eventCloudsManagementWsClient.deployPublishWsnService(topic));
                        LOG.info("New publish proxy for topic " + topic + " created");
                    }
                }

                //TODO : Replace by the following lines when bug fixed
                this.sendNotify(notify, this.publishProxies.get(topic));
                // UserManagementClientSOAP client = new
                // UserManagementClientSOAP(this.publishProxies.get(topic));
                // client.notify(notify);
            }
        } catch (WsnbException e) {
            // do nothing
            e.printStackTrace();
        } catch (SOAException e) {
            e.printStackTrace();
        }
    }

    private String getExpandedTopic(QName topic) {
        String expandedTopic = topic.getNamespaceURI();

        if (!expandedTopic.endsWith("/")) {
            expandedTopic += "/";
        }

        expandedTopic += topic.getLocalPart();

        return expandedTopic;
    }

    private void createEventCloudIfNotExist(String topic) {
        if (!this.topics.contains(topic)) {
            this.eventCloudsManagementWsClient.createEventCloud(topic);
            this.topics.add(topic);
            LOG.info("New Event Cloud for topic " + topic + " created");
        }
    }

    //TODO Remove when bug fixed
    private void sendNotify(EJaxbNotify notify, String address) {
        try {
            SOAPSender soapSender = new SOAPSender();
            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance()
                    .unmarshallAnyElement(notify));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address,
                    "http://com.petalslink.easyesb/service/admin/1.0/notify");

            if (soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder()
                        .newDocument();
                doc.appendChild(doc.importNode(SOAPHandler.getFaultDetails(soapResponse).get(0), true)
                        .cloneNode(true));
                SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStackTrace());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
            throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        // TODO: send unsubscribe on event cloud (optional)
        return null;
    }

    @Override
    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
            throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        // TODO: send getResourceProperty on event cloud (optional)
        return null;
    }

}
