package com.ebmwebsourcing.seacloud.cli.impl.command;

import java.io.ByteArrayInputStream;
import java.util.List;

import org.w3c.dom.Document;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.seacloud.client.SeaCloudClient;


public class AddDescriptorCommand extends AbstractCommand<SeaCloudClient> {

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class);
		} catch(Exception e) {
			// do nothing
		}
	}
	
	
	private String request;
	
	
	public AddDescriptorCommand(SeaCloudClient client) throws ESBException {
		super(client);
		this.setName("Add descriptor");
		this.setDescription("Add descriptor");
		this.setShortcut("ad");
	}
	
	@Override
	public void execute() {
		try {
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(request.getBytes()));
			System.out.println(XMLPrettyPrinter.prettyPrint(doc));
			AddResourcesDescriptor addRsc = new AddResourcesDescriptor();
			addRsc.setResourcesDescriptor(SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class));
			AddResourcesDescriptorResponse res = this.getClient().addResourcesDescriptor(addRsc);
			setResult("descriptor loaded");
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.request = args.get(0);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "da <url>  \t\t\t\t\t{Add descriptor in seacloud}";
	}
	
}
