package com.ebmwebsourcing.seacloud.cli.impl.command;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.seacloud.client.SeaCloudClient;

import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;


public class AddStatementWithActionsCommand extends AbstractCommand<SeaCloudClient> {

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class,
					engine.cep.admin.api.ObjectFactory.class);
		} catch(Exception e) {
			// do nothing
		}
	}
	
	
	private URL request;
	
	
	public AddStatementWithActionsCommand(SeaCloudClient client) throws ESBException {
		super(client);
		this.setName("Add Statement With Action");
		this.setDescription("Add Statement With Action");
		this.setShortcut("as");
	}
	
	@Override
	public void execute() {
		try {
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(request.openStream());
			System.out.println("AddStatementsWithActions: \n" + XMLPrettyPrinter.prettyPrint(doc));
			AddStatementWithActions addRsc = SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementWithActions.class);
			AddStatementResponseWithActions res = this.getClient().addStatementWithActions(addRsc);
			setResult("CEP Rules loaded");
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		try {
			this.request = new URL(args.get(0));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "da <url>  \t\t\t\t\t{Add descriptor in seacloud}";
	}
	
}
