package com.ebmwebsourcing.seacloud.cli.impl;

import com.ebmwebsourcing.easiergov.cli.impl.command.ConnectToEnvironmentCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.GOVConnectCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.PublishSchemaFromUrlCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.PublishTopicNamespaceFromUrlCommand;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.cli.impl.command.ConnectToGovernanceCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.DeployCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ExitCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.HelpCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.SendSoapRequestCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.seacloud.cli.impl.command.AddDescriptorCommand;
import com.ebmwebsourcing.seacloud.cli.impl.command.AddDescriptorFromURLCommand;
import com.ebmwebsourcing.seacloud.cli.impl.command.AddStatementWithActionsCommand;
import com.ebmwebsourcing.seacloud.cli.impl.command.SeaCloudConnectCommand;
import com.ebmwebsourcing.seacloud.cli.impl.command.SeaCloudScriptCommand;
import com.ebmwebsourcing.seacloud.client.SeaCloudClient;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;



public class SeaCloudCommandManager extends AbstractCommandManager {



	/**
	 * 
	 * @param node 
	 * @param petalsService
	 * @param petalsServer
	 * @throws ESBException 
	 * @throws ConnectionErrorException
	 * @throws PetalsAdminServiceErrorException
	 * @throws PetalsAdminDoesNotExistException
	 */
	public SeaCloudCommandManager() throws ESBException {
		super();
	}

	@Override
	public void init(String host) throws ESBException {

		this.connectionAddress = host;

		ConnexionManagerClientImplSOAP userClient = new ConnexionManagerClientImplSOAP(this.connectionAddress);
		SeaCloudClientSOAP seaClient = new SeaCloudClientSOAP(this.connectionAddress);
		UserManagementClientSOAP umClient = new UserManagementClientSOAP(this.connectionAddress);
		AdminManagementClientSOAP adminClient = new AdminManagementClientSOAP(this.connectionAddress);
		AdminClient baseClient = new AdminClientImpl(this.connectionAddress);
		EventManagerClientImplSOAP eventClient = new EventManagerClientImplSOAP(this.connectionAddress);
		DataManagerClientImplSOAP dataClient = new DataManagerClientImplSOAP(this.connectionAddress);
		
		// create the commands
		this.map.clear();
		addCommand(new SeaCloudConnectCommand(this));
		addCommand(new GOVConnectCommand(this));
		addCommand(new HelpCommand(this));
		addCommand(new ExitCommand(this));
		addCommand(new SeaCloudScriptCommand(userClient, this));

		if(this.connectionAddress != null) {
			addCommand(new DeployCommand(umClient));
			addCommand(new AddDescriptorCommand(seaClient));
			addCommand(new AddDescriptorFromURLCommand(seaClient));
			addCommand(new AddStatementWithActionsCommand(seaClient));
			addCommand(new SeaCloudConnectCommand(this));
			addCommand(new GOVConnectCommand(this));
			addCommand(new ConnectToEnvironmentCommand(userClient));
			addCommand(new ConnectToGovernanceCommand(baseClient));
			addCommand(new SendSoapRequestCommand(umClient));
			addCommand(new PublishTopicNamespaceFromUrlCommand(eventClient));
			addCommand(new PublishSchemaFromUrlCommand(dataClient));
		} else {
			
		}
	}

}
