package com.ebmwebsourcing.seacloud.cli.impl.command;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easiergov.cli.impl.command.ConnectToEnvironmentCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.PublishSchemaFromUrlCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.PublishTopicNamespaceFromUrlCommand;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.cli.impl.command.AbstractScriptCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ConnectToGovernanceCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.DeployCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.SendSoapRequestCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

public class SeaCloudScriptCommand extends AbstractScriptCommand<ConnexionManagerClientImplSOAP> {


	public SeaCloudScriptCommand(ConnexionManagerClientImplSOAP client, AbstractCommandManager cm) throws ESBException {
		super(client, cm);
	}

	public String executeAction(Element command) {
		String res = null;
		System.out.println("Command name: " + command.getName());
		if("ConnectToEnvironment".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			ConnectToEnvironmentCommand impl = (ConnectToEnvironmentCommand) cm.findCommand("co");
			impl.process(args);

			res = "Connect To Environment: " + impl.getResult();
		} else if("AddDescriptor".equals(command.getName())){
			Element desc = command.getChild("resourcesDescriptor", Namespace.getNamespace("http://com.petalslink.seacloud/data/1.0"));

			List<String> args = new ArrayList<String>();
			args.add(new XMLOutputter(Format.getPrettyFormat()).outputString(desc));

			AddDescriptorCommand impl = (AddDescriptorCommand) cm.findCommand("ad");
			impl.process(args);

			res = "Add descriptor to seacloud : " + impl.getResult();
		} else if("AddDescriptorFromURL".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			AddDescriptorFromURLCommand impl = (AddDescriptorFromURLCommand) cm.findCommand("adfu");
			impl.process(args);
			
			res = "Add descriptor from url to seacloud : " + impl.getResult();
		} else if("AddStatementWithActions".equals(command.getName())){
			Element desc = command.getChild("addStatementWithActions", Namespace.getNamespace("http://api.admin.cep.engine/"));

			List<String> args = new ArrayList<String>();
			args.add(new XMLOutputter(Format.getPrettyFormat()).outputString(desc));

			AddStatementWithActionsCommand impl = (AddStatementWithActionsCommand) cm.findCommand("as");
			impl.process(args);

			res = "Add cep rules to seacloud : " + impl.getResult();
		} else if("AddStatementWithActionsFromUrl".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();

			List<String> args = new ArrayList<String>();
			args.add(url);

			AddStatementWithActionsFromURLCommand impl = (AddStatementWithActionsFromURLCommand) cm.findCommand("asu");
			impl.process(args);

			res = "Add cep rules to seacloud : " + impl.getResult();
		} else if("Deploy".equals(command.getName())){

			String main = command.getChild("MainResource", Command.NAMESPACE_JDOM).getTextTrim();
			List resourcesElement = command.getChildren("Resource", Command.NAMESPACE_JDOM);
			List<String> resources = new ArrayList<String>();
			resources.add(main);
			for(int i=0 ; i<resourcesElement.size() ; i++){
				resources.add(((Element)resourcesElement.get(i)).getTextTrim());
			}
			DeployCommand deploy = (DeployCommand) cm.findCommand("d");
			deploy.process(resources);

			res = "Deploy : "+deploy.getResult();
		} else if("SendSoapRequest".equals(command.getName())){

			String request = new XMLOutputter(Format.getPrettyFormat()).outputString(command.getChild("Request", Command.NAMESPACE_JDOM).getChild("Envelope", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/")));
			String soapAction = command.getChildText("SoapAction", Command.NAMESPACE_JDOM).trim();

			List<String> args = new ArrayList<String>();
			args.add(request);
			args.add(soapAction);

			try {
				SendSoapRequestCommand proxy = (SendSoapRequestCommand) cm.findCommand("ss");
				proxy.process(args);

				res = "Send Soap Request. Receive response : \n"+proxy.getResult();
				System.out.println("Send Soap Request. Receive response : \n"+proxy.getResult());
			} catch(Throwable e) {
				e.printStackTrace();
			}
		} else if("ConnectToGovernance".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			System.out.println("Governance url: " + url);
			List<String> args = new ArrayList<String>();
			args.add(url);

			ConnectToGovernanceCommand impl = (ConnectToGovernanceCommand) cm.findCommand("cog");
			impl.process(args);

			res = "Connect To governance: " + impl.getResult();
		} else if("PublishTopicNamespaceFromURL".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			PublishTopicNamespaceFromUrlCommand impl = (PublishTopicNamespaceFromUrlCommand) cm.findCommand("pt");
			impl.process(args);

			res = "PublishTopicNamespaceFromURL: " + impl.getResult();
		} else if("PublishSchemaFromURL".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			PublishSchemaFromUrlCommand impl = (PublishSchemaFromUrlCommand) cm.findCommand("psc");
			impl.process(args);

			res = "PublishSchemaFromURL: " + impl.getResult();
		} else {
			System.out.println("Unknown command: " + command);
		} 
		return res;
	}

}
