/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.cli.impl.command;

import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import java.util.List;
import seacloud.petalslink.com.data._1.ObjectFactory;

public class AddDescriptorFromURLCommand
extends AbstractCommand<SeaCloudClientSOAP> {
    private String url;

    public AddDescriptorFromURLCommand(SeaCloudClientSOAP client) throws ESBException {
        super((Object)client);
        this.setName("Add descriptor from URL");
        this.setDescription("Add descriptor from URL");
        this.setShortcut("adfu");
    }

    public void execute() {
        try {
            System.out.println("send descriptor : " + this.url + " to " + ((SeaCloudClientSOAP)this.getClient()).getAddress());
            ((SeaCloudClientSOAP)this.getClient()).addResourcesDescriptorFromURL(this.url, true);
            this.setResult("descriptor loaded");
            this.resultCode = 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    protected int doProcess(List<String> args) {
        this.url = args.get(0);
        this.execute();
        return this.resultCode;
    }

    protected boolean validateArgs(List<String> args) {
        return args.size() == 1;
    }

    public String toString() {
        return "da <url>  \t\t\t\t\t{Add descriptor in seacloud}";
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

