package com.ebmwebsourcing.seacloud.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.seacloud.client.SeaCloudClient;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;


public class AddDescriptorFromURLCommand extends AbstractCommand<SeaCloudClientSOAP> {

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class);
		} catch(Exception e) {
			// do nothing
		}
	}
	
	
	private String url;
	
	
	public AddDescriptorFromURLCommand(SeaCloudClientSOAP client) throws ESBException {
		super(client);
		this.setName("Add descriptor from URL");
		this.setDescription("Add descriptor from URL");
		this.setShortcut("adfu");
	}
	
	@Override
	public void execute() {
		try {
			System.out.println("send descriptor : " + url + " to " + this.getClient().getAddress());
			this.getClient().addResourcesDescriptorFromURL(url, true);
			setResult("descriptor loaded");
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			e.printStackTrace();
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "da <url>  \t\t\t\t\t{Add descriptor in seacloud}";
	}
	
}
