// SOCEDA integration
// ---------
// -- CEP --
// ---------

// Current cep is a light mocked version
// TODO: Replace by the final cep
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var cepComponentKey = "cep";
var cepConfigFilename = "cep.config.properties";

function runCEP() {
	println("Checking CEP installation ... ");

	// Check if already installed
	var cepDir = new File(instDir, cepComponentKey);
	if (!cepDir.exists() || cepDir.listFiles().length == 0) {
		println("CEP not found, trying to install ...");
		cepDir.mkdir();

		// Check if the installer is in origin
		var cepInstallerFile = new File(originDir, findInstallerNameOfComponent(cepComponentKey));
		if (!cepInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(cepComponentKey);
			println("Trying to download the the CEP installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, cepInstallerFile);
			} catch (e) {
				println("Unable to download the CEP installer " + e.javaStackTrace);
			}
			
			if (!cepInstallerFile.exists()) {
				throw "Unable to find " + cepInstallerFile + " please download "
				+ cepInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract DiCEPE binaries from the installer package
		try {
			extractFolder(cepInstallerFile, cepDir);
		} catch (e) {
			println("Unable to extract CEP binaries " + e.javaStackTrace);
		}
		
		if (cepDir.listFiles().length == 0) {
			throw "Unable to extract CEP please extract " + cepInstallerFile + " manually into " + cepDir;
		}
		
		println("Installation successfull ...");
	}
	
	var binDir = new File(cepDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, cepConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	var logSrcFile = new File(configDir, "logger.properties");
	var logDstFile = new File(binDir, "logger.properties");
	try {
		println("Copying " + logSrcFile + " into " + logDstFile.getParent());		
		copyFile(logSrcFile, logDstFile);
	} catch (e) {
		println("!! Unable to copy " + logSrcFile + " logger file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}

	deleteLockedFile(binDir);
	
	// Running cep from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'cep-light.jar', 'start');
	return execCmdNewTermAsync("CEP", cmd, binDir);
}