// SOCEDA integration
// --------------
// -- SeaCloud --
// --------------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var scComponentKey = "sc";
var scConfigFilename = "sc.config.properties";

function runSC() {
	println("Checking SeaCloud installation ... ");

	// Check if already installed
	var scDir = new File(instDir, scComponentKey);
	if (!scDir.exists() || scDir.listFiles().length == 0) {
		println("SeaCloud not found, trying to install ...");
		scDir.mkdir();

		// Check if the installer is in origin
		var scInstallerFile = new File(originDir, findInstallerNameOfComponent(scComponentKey));
		if (!scInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(scComponentKey);
			println("Trying to download the SeaCloud installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, scInstallerFile);
			} catch (e) {
				println("Unable to download the SeaCloud installer " + e.javaStackTrace);
			}
			
			if (!scInstallerFile.exists()) {
				throw "Unable to find " + scInstallerFile + " please download "
				+ scInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(scInstallerFile, scDir);
		} catch (e) {
			println("Unable to extract SeaCloud binaries " + e.javaStackTrace);
		}
		
		if (scDir.listFiles().length == 0) {
			throw "Unable to extract SeaCloud please extract " + scInstallerFile + " manually into " + scDir;
		}
		
		println("Installation successfull ...");
	}
	
	var binDir = new File(scDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, scConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	var logSrcFile = new File(configDir, "logger.properties");
	var logDstFile = new File(binDir, "logger.properties");
	try {
		println("Copying " + logSrcFile + " into " + logDstFile.getParent());		
		copyFile(logSrcFile, logDstFile);
	} catch (e) {
		println("!! Unable to copy " + logSrcFile + " logger file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);

	// Running sc from bin dir
	//java %JAVA_OPTS% %DEBUG_OPTS% -jar "server-soceda.jar" start useMock
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}

	cmd.push('-jar', 'server.jar', 'start', 'useMock');
	return execCmdNewTermAsync("SeaCloud", cmd, binDir);
}