//SOCEDA integration
//----------
//-- Main --
//----------
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

//Load files
load("src/util.js");
load("src/dsb.js"); // EasyESB
load("src/gov.js"); // EasierGOV
load("src/bsm.js"); // EasierBSM
load("src/sc.js"); // SeaCloud
load("src/ec.js"); // EventCloud
load("src/ceped.js"); // CEPEditor
load("src/cep.js"); // CEP (ie DiCEPE)
load("src/ela.js"); // ELA
load("src/sccli.js"); // SeaCloud CLI

{
	println("--------------------------------------------");
	println("--   Welcome to SOCEDA Framework With Mock " + findPropertyInInstaller("installer.version") + "  --");
	println("--         http://www.soceda.org          --");
	println("--------------------------------------------");

	// Check current dir
	checkCurrentLocation();

	// Install SeaCloud CLI
	installSCCLI();

	// Start all components of Soceda Framework
	var waiterThread = startAllComponents();

	println("Please wait until all components are started ...");

	readStdin("Once ready press 'Enter' to connect all components of the SOCEDA Framework ...");
	connectAllComponents();

	println(""); 
	println("Congratulation!!!"); 
	println("The SOCEDA Framework is ready...");

	// The main will terminate when the waiter thread terminates
	waiterThread.join();
}


function startAllComponents() {
	// Start CEP Mocked
	var cepProcess = runCEP();
	println("CEP started ...");

	// Start EventCloud Mocked	
	var ecProcess = runEC();
	println("EventCloud started ...");		

	// Start EasierGOV
	var govProcess = runGOV();
	println("EasierGOV started ...");

	// Start EasierESB
	var dsbProcess = runDSB();
	println("EasyESB started ...");	

	// Start EasierBSM
	var bsmProcess = runBSM();
	println("EasierBSM started ...");	
	
	// Start ELA ALERT Service
	var elaProcess = runELA();
	println("ELA Alert Service started ...");	

	// Start SeaCloud
	var scProcess = runSC();
	println("SeaCloud started ...");



	// Run CEP Editor
	//var cepedProcess = runCEPED();
	//println("CEP Editor created ...");	

	// Add hook that terminates all if the current process is killed 
	var cleaner = java.lang.Thread(function () {

		println("Terminating EasyESB ...");
		dsbProcess.destroy();
		println("Terminating EasierGOV ...");
		govProcess.destroy();
		println("Terminating EasierBSM ...");
		bsmProcess.destroy();
		println("Terminating ELA Alert Service ...");
		elaProcess.destroy();
		println("Terminating EventCloud ...");
		ecProcess.destroy();
		//println("Terminating CEPEditor ...");
		//cepedProcess.destroy();
		println("Terminating SeaCloud ...");
		scProcess.destroy();
		println("Terminating CEP ...");
		cepProcess.destroy();
	});
	java.lang.Runtime.getRuntime().addShutdownHook(cleaner);

	// Add async waiter thread 
	var waiter = java.lang.Thread(function () {
		// Wait for 
		dsbProcess.waitFor();
		govProcess.waitFor();
		bsmProcess.waitFor();
		elaProcess.waitFor();
		ecProcess.waitFor();	

		//cepedProcess.waitFor();
		scProcess.waitFor();
		cepProcess.waitFor();
	});
	waiter.start();
	return waiter;
}

function connectAllComponents() {
	var scriptFile = new File(scriptsDir, "ConnectAllComponentsScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();	
}

