importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);
// SOCEDA integration
// - dsb.js starts EasyESB
// - gov.js starts EasierGOV
// - sc.js starts SeaCloud
// - ec.js starts EventCloud
// - ws.js starts WebService Provider
// - ceped.js starts CEPEditor
// - dicepe.js starts DiCEPE

// Load files
load("src/util.js");
load("src/dsb.js");
load("src/gov.js");
load("src/sc.js");
load("src/ec.js");
load("src/ws.js");
load("src/ceped.js");
load("src/dicepe.js");
load("src/config.js");

{
	println("Running SOCEDA integration ...");

	// Check current dir
	checkCurrentLocation();
	
	// create tmux session
	createTmuxSessionIfNeeded();
		
	// Run DSB
	var dsbProcess = runDSB();
	println("DSB created ...");

	// Run GOV
	var govProcess = runGOV();
	println("GOV created ...");

	// Run EventCloud
	var ecProcess = runEC();
	println("EventCloud created ...");		
	
	// Run WebService Providers
	var wsProcesses = runWS();
	println("WebService Providers created ...");	
	
	// Run CEP Editor
	var cepedProcess = runCEPED();
	println("CEP Editor created ...");
	
	// Run SeaCloud
	var scProcess = runSC();
	println("SeaCloud created ...");	
	
	// Run DiCEPE
	var dicepeProcess = runDiCEPE();
	println("DiCEPE created ...");
		
	// Terminate all if the current process is killed 
	var cleaner = java.lang.Thread(function () { 
		println("Terminating DSB ...");
		dsbProcess.destroy();
		println("Terminating GOV ...");
		govProcess.destroy();
		println("Terminating EventCloud ...");
		ecProcess.destroy();
		println("Terminating WebService Providers ...");		
		for (x in wsProcesses) {
			var proc = wsProcesses[x];
			if (proc != null) {  
				proc.destroy();
			}
		}	
		println("Terminating CEPEditor ...");
		cepedProcess.destroy();
		println("Terminating SeaCloud ...");
		scProcess.destroy();
		println("Terminating DiCEPE ...");
		dicepeProcess.destroy();
	});
	java.lang.Runtime.getRuntime().addShutdownHook(cleaner);
	
	waitForever();
	
	dsbProcess.waitFor();
	govProcess.waitFor();
	ecProcess.waitFor();	
	for (x in wsProcesses) {
		wsProcesses[x].waitFor();
	}	
	shutdownTomcat();
	cepedProcess.waitFor();
	scProcess.waitFor();
	dicepeProcess.waitFor();
}