// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

// TODO: ADD DOWNLOAD OF INSTALLER
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var scportal = "scportal";
var tomcat = "tomcat";

function runSCPortal() {
	println("Checking SeaCloud Portal installation ... ");

	// Check if already installed
	var scportalDir = new File(instDir, scportal);
	var tomcatDir = new File(instDir, tomcat);
	if (!scportalDir.exists() || scportalDir.listFiles().length == 0) {
		println("SeaCloud Portal not found, trying to install ...");
		scportalDir.mkdir();

		// Check if the installer is in origin
		var scportalInstallerFile = new File(originDir, findInstallerNameOfComponent(scportal));
		if (!scportalInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(scportal);
			println("Trying to download the SeaCloud Portal installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, scportalInstallerFile);
			} catch (e) {
				println("Unable to download the SeaCloud Portal installer due to " + e.javaException);
			}
			
			if (!scportalInstallerFile.exists()) {
				throw "Unable to find " + scportalInstallerFile + " please download "
				+ tomcatInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// move war to tomcat
		try {
			println("copy file " + scportalInstallerFile + " to " + tomcatDir + "/webapps/" + findInstallerNameOfComponent(scportal));
			copyFile(scportalInstallerFile, new File(tomcatDir, "/webapps/" + findInstallerNameOfComponent(scportal)));
		} catch (e) {
			println("Unable to extract Tomcat binaries " + e.javaStackTrace);
		}
		
		if (tomcatDir.listFiles().length == 0) {
			throw "Unable to extract Tomcat please extract " + tomcatInstallerFile + " manually into " + tomcatDir;
		}
		
		println("SeaCloud Portal Installation successfull ...");
	}
	
//	var apacheTomcatDir = new File(tomcatDir);
//	if (!apacheTomcatDir.exists()) {
//		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct Tomcat archive in " + tomcatDir;
//	}
//	var binDir = new File(apacheTomcatDir, "bin");	
//	var startupFile = new File(binDir, "startup"+ (isWindows ? ".bat" : ".sh"));	
//	var cmd = [ startupFile.getAbsolutePath() ];	
//	var tomcatProcess = execCmdNewTermAsync("Apache Tomcat", cmd, binDir);
		
//	var port = 8080;	
//	while (isPortAvailable(port)) {
//		println("Waiting for apache tomcat before opening the Tomcat web page ...");
//		java.lang.Thread.sleep(1000);
//	}
//		
//	// Start a new 
//	execCmdNewTermAsync("SeaCloud Portal web page", ["http://localhost:"+port+"/SCPortal.html"], binDir);
//	
//	// TODO: Find a way to kill tomcat
//	return tomcatProcess;
}