// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

load("src/scportal.js");
load("src/ceped.js");

// TODO: ADD DOWNLOAD OF INSTALLER
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);


var apacheTomcatName = "apache-tomcat-7.0.35";
var tomcat = "tomcat";

function runTomcat() {
	println("Checking Tomcat installation ... ");

	// Check if already installed
	var tomcatDir = new File(instDir, tomcat);
	if (!tomcatDir.exists() || tomcatDir.listFiles().length == 0) {
		println("Tomcat not found, trying to install ...");
		tomcatDir.mkdir();

		// Check if the installer is in origin
		var tomcatInstallerFile = new File(originDir, findInstallerNameOfComponent(tomcat));
		if (!tomcatInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(tomcat);
			println("Trying to download the Tomcat installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, tomcatInstallerFile);
			} catch (e) {
				println("Unable to download the Tomcat installer due to " + e.javaException);
			}
			
			if (!tomcatInstallerFile.exists()) {
				throw "Unable to find " + tomcatInstallerFile + " please download "
				+ tomcatInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract Tomcat binaries from the installer package
		try {
			extractFolder(tomcatInstallerFile, tomcatDir);
		} catch (e) {
			println("Unable to extract Tomcat binaries " + e.javaStackTrace);
		}
		
		if (tomcatDir.listFiles().length == 0) {
			throw "Unable to extract Tomcat please extract " + tomcatInstallerFile + " manually into " + tomcatDir;
		}
		
		println("Installation successfull ...");
	}
	
	var apacheTomcatDir = new File(tomcatDir);
	if (!apacheTomcatDir.exists()) {
		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct Tomcat archive in " + tomcatDir;
	}
	var binDir = new File(apacheTomcatDir, "bin");	
	var startupFile = new File(binDir, "startup"+ (isWindows ? ".bat" : ".sh"));	
	var cmd = [ startupFile.getAbsolutePath() ];	
	
	runSCPortal();
	runCEPEditor();
	
	var tomcatProcess = execCmdNewTermAsync("Apache Tomcat", cmd, binDir);
		
	var port = 8080;	
	while (isPortAvailable(port)) {
		println("Waiting for apache tomcat before opening the Tomcat web page ...");
		java.lang.Thread.sleep(1000);
	}
		
	// Start a new 
	execCmdNewTermAsync("SeaCloud Portal web page", ["http://localhost:"+port+"/seacloud-portal-" + findPropertyInInstaller("installer.version") + "/"], binDir);
	
	// TODO: Find a way to kill tomcat
	return tomcatProcess;
}